package zio.aws.codestar.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codestar.model.primitives.{TagValue, TagKey}
import scala.jdk.CollectionConverters.*
final case class TagProjectResponse(
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestar.model.TagProjectResponse = {
    import TagProjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestar.model.TagProjectResponse
      .builder()
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.codestar.model.TagProjectResponse.ReadOnly =
    zio.aws.codestar.model.TagProjectResponse.wrap(buildAwsValue())
}
object TagProjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestar.model.TagProjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestar.model.TagProjectResponse =
      zio.aws.codestar.model.TagProjectResponse(tags.map(value => value))
    def tags: Optional[Map[TagKey, TagValue]]
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestar.model.TagProjectResponse
  ) extends zio.aws.codestar.model.TagProjectResponse.ReadOnly {
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.codestar.model.primitives
              .TagKey(key) -> zio.aws.codestar.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestar.model.TagProjectResponse
  ): zio.aws.codestar.model.TagProjectResponse.ReadOnly = new Wrapper(impl)
}
