package zio.aws.codestar.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codestar.model.primitives.ResourceId
import scala.jdk.CollectionConverters.*
final case class Resource(id: ResourceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestar.model.Resource = {
    import Resource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestar.model.Resource
      .builder()
      .id(ResourceId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codestar.model.Resource.ReadOnly =
    zio.aws.codestar.model.Resource.wrap(buildAwsValue())
}
object Resource {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.codestar.model.Resource] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestar.model.Resource =
      zio.aws.codestar.model.Resource(id)
    def id: ResourceId
    def getId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestar.model.Resource
  ) extends zio.aws.codestar.model.Resource.ReadOnly {
    override val id: ResourceId =
      zio.aws.codestar.model.primitives.ResourceId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestar.model.Resource
  ): zio.aws.codestar.model.Resource.ReadOnly = new Wrapper(impl)
}
