package zio.aws.codestar.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codestar.model.primitives.{
  SshPublicKey,
  Email,
  UserProfileDisplayName,
  UserArn
}
import scala.jdk.CollectionConverters.*
final case class UserProfileSummary(
    userArn: Optional[UserArn] = Optional.Absent,
    displayName: Optional[UserProfileDisplayName] = Optional.Absent,
    emailAddress: Optional[Email] = Optional.Absent,
    sshPublicKey: Optional[SshPublicKey] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestar.model.UserProfileSummary = {
    import UserProfileSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestar.model.UserProfileSummary
      .builder()
      .optionallyWith(
        userArn.map(value => UserArn.unwrap(value): java.lang.String)
      )(_.userArn)
      .optionallyWith(
        displayName.map(value =>
          UserProfileDisplayName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .optionallyWith(
        emailAddress.map(value => Email.unwrap(value): java.lang.String)
      )(_.emailAddress)
      .optionallyWith(
        sshPublicKey.map(value => SshPublicKey.unwrap(value): java.lang.String)
      )(_.sshPublicKey)
      .build()
  }
  def asReadOnly: zio.aws.codestar.model.UserProfileSummary.ReadOnly =
    zio.aws.codestar.model.UserProfileSummary.wrap(buildAwsValue())
}
object UserProfileSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestar.model.UserProfileSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestar.model.UserProfileSummary =
      zio.aws.codestar.model.UserProfileSummary(
        userArn.map(value => value),
        displayName.map(value => value),
        emailAddress.map(value => value),
        sshPublicKey.map(value => value)
      )
    def userArn: Optional[UserArn]
    def displayName: Optional[UserProfileDisplayName]
    def emailAddress: Optional[Email]
    def sshPublicKey: Optional[SshPublicKey]
    def getUserArn: ZIO[Any, AwsError, UserArn] =
      AwsError.unwrapOptionField("userArn", userArn)
    def getDisplayName: ZIO[Any, AwsError, UserProfileDisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getEmailAddress: ZIO[Any, AwsError, Email] =
      AwsError.unwrapOptionField("emailAddress", emailAddress)
    def getSshPublicKey: ZIO[Any, AwsError, SshPublicKey] =
      AwsError.unwrapOptionField("sshPublicKey", sshPublicKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestar.model.UserProfileSummary
  ) extends zio.aws.codestar.model.UserProfileSummary.ReadOnly {
    override val userArn: Optional[UserArn] = zio.aws.core.internal
      .optionalFromNullable(impl.userArn())
      .map(value => zio.aws.codestar.model.primitives.UserArn(value))
    override val displayName: Optional[UserProfileDisplayName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.displayName())
        .map(value =>
          zio.aws.codestar.model.primitives.UserProfileDisplayName(value)
        )
    override val emailAddress: Optional[Email] = zio.aws.core.internal
      .optionalFromNullable(impl.emailAddress())
      .map(value => zio.aws.codestar.model.primitives.Email(value))
    override val sshPublicKey: Optional[SshPublicKey] = zio.aws.core.internal
      .optionalFromNullable(impl.sshPublicKey())
      .map(value => zio.aws.codestar.model.primitives.SshPublicKey(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestar.model.UserProfileSummary
  ): zio.aws.codestar.model.UserProfileSummary.ReadOnly = new Wrapper(impl)
}
