package zio.aws.codestar.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ToolchainSource(s3: zio.aws.codestar.model.S3Location) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestar.model.ToolchainSource = {
    import ToolchainSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestar.model.ToolchainSource
      .builder()
      .s3(s3.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.codestar.model.ToolchainSource.ReadOnly =
    zio.aws.codestar.model.ToolchainSource.wrap(buildAwsValue())
}
object ToolchainSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestar.model.ToolchainSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestar.model.ToolchainSource =
      zio.aws.codestar.model.ToolchainSource(s3.asEditable)
    def s3: zio.aws.codestar.model.S3Location.ReadOnly
    def getS3: ZIO[Any, Nothing, zio.aws.codestar.model.S3Location.ReadOnly] =
      ZIO.succeed(s3)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestar.model.ToolchainSource
  ) extends zio.aws.codestar.model.ToolchainSource.ReadOnly {
    override val s3: zio.aws.codestar.model.S3Location.ReadOnly =
      zio.aws.codestar.model.S3Location.wrap(impl.s3())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestar.model.ToolchainSource
  ): zio.aws.codestar.model.ToolchainSource.ReadOnly = new Wrapper(impl)
}
