package zio.aws.codestar.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.codestar.model.primitives.{
  ProjectName,
  ProjectId,
  ClientRequestToken,
  CreatedTimestamp,
  ProjectDescription,
  ProjectArn,
  StackId,
  ProjectTemplateId
}
import scala.jdk.CollectionConverters.*
final case class DescribeProjectResponse(
    name: Option[ProjectName] = None,
    id: Option[ProjectId] = None,
    arn: Option[ProjectArn] = None,
    description: Option[ProjectDescription] = None,
    clientRequestToken: Option[ClientRequestToken] = None,
    createdTimeStamp: Option[CreatedTimestamp] = None,
    stackId: Option[StackId] = None,
    projectTemplateId: Option[ProjectTemplateId] = None,
    status: Option[zio.aws.codestar.model.ProjectStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestar.model.DescribeProjectResponse = {
    import DescribeProjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestar.model.DescribeProjectResponse
      .builder()
      .optionallyWith(
        name.map(value => ProjectName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        id.map(value => ProjectId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        arn.map(value => ProjectArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        description.map(value =>
          ProjectDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        createdTimeStamp.map(value => CreatedTimestamp.unwrap(value): Instant)
      )(_.createdTimeStamp)
      .optionallyWith(
        stackId.map(value => StackId.unwrap(value): java.lang.String)
      )(_.stackId)
      .optionallyWith(
        projectTemplateId.map(value =>
          ProjectTemplateId.unwrap(value): java.lang.String
        )
      )(_.projectTemplateId)
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.codestar.model.DescribeProjectResponse.ReadOnly =
    zio.aws.codestar.model.DescribeProjectResponse.wrap(buildAwsValue())
}
object DescribeProjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestar.model.DescribeProjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestar.model.DescribeProjectResponse =
      zio.aws.codestar.model.DescribeProjectResponse(
        name.map(value => value),
        id.map(value => value),
        arn.map(value => value),
        description.map(value => value),
        clientRequestToken.map(value => value),
        createdTimeStamp.map(value => value),
        stackId.map(value => value),
        projectTemplateId.map(value => value),
        status.map(value => value.asEditable)
      )
    def name: Option[ProjectName]
    def id: Option[ProjectId]
    def arn: Option[ProjectArn]
    def description: Option[ProjectDescription]
    def clientRequestToken: Option[ClientRequestToken]
    def createdTimeStamp: Option[CreatedTimestamp]
    def stackId: Option[StackId]
    def projectTemplateId: Option[ProjectTemplateId]
    def status: Option[zio.aws.codestar.model.ProjectStatus.ReadOnly]
    def getName: ZIO[Any, AwsError, ProjectName] =
      AwsError.unwrapOptionField("name", name)
    def getId: ZIO[Any, AwsError, ProjectId] =
      AwsError.unwrapOptionField("id", id)
    def getArn: ZIO[Any, AwsError, ProjectArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getDescription: ZIO[Any, AwsError, ProjectDescription] =
      AwsError.unwrapOptionField("description", description)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getCreatedTimeStamp: ZIO[Any, AwsError, CreatedTimestamp] =
      AwsError.unwrapOptionField("createdTimeStamp", createdTimeStamp)
    def getStackId: ZIO[Any, AwsError, StackId] =
      AwsError.unwrapOptionField("stackId", stackId)
    def getProjectTemplateId: ZIO[Any, AwsError, ProjectTemplateId] =
      AwsError.unwrapOptionField("projectTemplateId", projectTemplateId)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.codestar.model.ProjectStatus.ReadOnly] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestar.model.DescribeProjectResponse
  ) extends zio.aws.codestar.model.DescribeProjectResponse.ReadOnly {
    override val name: Option[ProjectName] = scala
      .Option(impl.name())
      .map(value => zio.aws.codestar.model.primitives.ProjectName(value))
    override val id: Option[ProjectId] = scala
      .Option(impl.id())
      .map(value => zio.aws.codestar.model.primitives.ProjectId(value))
    override val arn: Option[ProjectArn] = scala
      .Option(impl.arn())
      .map(value => zio.aws.codestar.model.primitives.ProjectArn(value))
    override val description: Option[ProjectDescription] = scala
      .Option(impl.description())
      .map(value => zio.aws.codestar.model.primitives.ProjectDescription(value))
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value => zio.aws.codestar.model.primitives.ClientRequestToken(value))
    override val createdTimeStamp: Option[CreatedTimestamp] = scala
      .Option(impl.createdTimeStamp())
      .map(value => zio.aws.codestar.model.primitives.CreatedTimestamp(value))
    override val stackId: Option[StackId] = scala
      .Option(impl.stackId())
      .map(value => zio.aws.codestar.model.primitives.StackId(value))
    override val projectTemplateId: Option[ProjectTemplateId] = scala
      .Option(impl.projectTemplateId())
      .map(value => zio.aws.codestar.model.primitives.ProjectTemplateId(value))
    override val status: Option[zio.aws.codestar.model.ProjectStatus.ReadOnly] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.codestar.model.ProjectStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestar.model.DescribeProjectResponse
  ): zio.aws.codestar.model.DescribeProjectResponse.ReadOnly = new Wrapper(impl)
}
