package zio.aws.codestar.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codestar.model.primitives.{ProjectArn, StackId}
import scala.jdk.CollectionConverters.*
final case class DeleteProjectResponse(
    stackId: Option[StackId] = None,
    projectArn: Option[ProjectArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestar.model.DeleteProjectResponse = {
    import DeleteProjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestar.model.DeleteProjectResponse
      .builder()
      .optionallyWith(
        stackId.map(value => StackId.unwrap(value): java.lang.String)
      )(_.stackId)
      .optionallyWith(
        projectArn.map(value => ProjectArn.unwrap(value): java.lang.String)
      )(_.projectArn)
      .build()
  }
  def asReadOnly: zio.aws.codestar.model.DeleteProjectResponse.ReadOnly =
    zio.aws.codestar.model.DeleteProjectResponse.wrap(buildAwsValue())
}
object DeleteProjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestar.model.DeleteProjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestar.model.DeleteProjectResponse =
      zio.aws.codestar.model.DeleteProjectResponse(
        stackId.map(value => value),
        projectArn.map(value => value)
      )
    def stackId: Option[StackId]
    def projectArn: Option[ProjectArn]
    def getStackId: ZIO[Any, AwsError, StackId] =
      AwsError.unwrapOptionField("stackId", stackId)
    def getProjectArn: ZIO[Any, AwsError, ProjectArn] =
      AwsError.unwrapOptionField("projectArn", projectArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestar.model.DeleteProjectResponse
  ) extends zio.aws.codestar.model.DeleteProjectResponse.ReadOnly {
    override val stackId: Option[StackId] = scala
      .Option(impl.stackId())
      .map(value => zio.aws.codestar.model.primitives.StackId(value))
    override val projectArn: Option[ProjectArn] = scala
      .Option(impl.projectArn())
      .map(value => zio.aws.codestar.model.primitives.ProjectArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestar.model.DeleteProjectResponse
  ): zio.aws.codestar.model.DeleteProjectResponse.ReadOnly = new Wrapper(impl)
}
