package zio.aws.codestar.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codestar.model.primitives.{
  ProjectDescription,
  ProjectName,
  ProjectId
}
import scala.jdk.CollectionConverters.*
final case class UpdateProjectRequest(
    id: ProjectId,
    name: Option[ProjectName] = None,
    description: Option[ProjectDescription] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestar.model.UpdateProjectRequest = {
    import UpdateProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestar.model.UpdateProjectRequest
      .builder()
      .id(ProjectId.unwrap(id): java.lang.String)
      .optionallyWith(
        name.map(value => ProjectName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          ProjectDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.codestar.model.UpdateProjectRequest.ReadOnly =
    zio.aws.codestar.model.UpdateProjectRequest.wrap(buildAwsValue())
}
object UpdateProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestar.model.UpdateProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestar.model.UpdateProjectRequest =
      zio.aws.codestar.model.UpdateProjectRequest(
        id,
        name.map(value => value),
        description.map(value => value)
      )
    def id: ProjectId
    def name: Option[ProjectName]
    def description: Option[ProjectDescription]
    def getId: ZIO[Any, Nothing, ProjectId] = ZIO.succeed(id)
    def getName: ZIO[Any, AwsError, ProjectName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, ProjectDescription] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestar.model.UpdateProjectRequest
  ) extends zio.aws.codestar.model.UpdateProjectRequest.ReadOnly {
    override val id: ProjectId =
      zio.aws.codestar.model.primitives.ProjectId(impl.id())
    override val name: Option[ProjectName] = scala
      .Option(impl.name())
      .map(value => zio.aws.codestar.model.primitives.ProjectName(value))
    override val description: Option[ProjectDescription] = scala
      .Option(impl.description())
      .map(value => zio.aws.codestar.model.primitives.ProjectDescription(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestar.model.UpdateProjectRequest
  ): zio.aws.codestar.model.UpdateProjectRequest.ReadOnly = new Wrapper(impl)
}
