package zio.aws.codestar.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codestar.model.primitives.{
  MaxResults,
  PaginationToken,
  ProjectId
}
import scala.jdk.CollectionConverters.*
final case class ListTagsForProjectRequest(
    id: ProjectId,
    nextToken: Option[PaginationToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestar.model.ListTagsForProjectRequest = {
    import ListTagsForProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestar.model.ListTagsForProjectRequest
      .builder()
      .id(ProjectId.unwrap(id): java.lang.String)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.codestar.model.ListTagsForProjectRequest.ReadOnly =
    zio.aws.codestar.model.ListTagsForProjectRequest.wrap(buildAwsValue())
}
object ListTagsForProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestar.model.ListTagsForProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestar.model.ListTagsForProjectRequest =
      zio.aws.codestar.model.ListTagsForProjectRequest(
        id,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def id: ProjectId
    def nextToken: Option[PaginationToken]
    def maxResults: Option[MaxResults]
    def getId: ZIO[Any, Nothing, ProjectId] = ZIO.succeed(id)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestar.model.ListTagsForProjectRequest
  ) extends zio.aws.codestar.model.ListTagsForProjectRequest.ReadOnly {
    override val id: ProjectId =
      zio.aws.codestar.model.primitives.ProjectId(impl.id())
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.codestar.model.primitives.PaginationToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.codestar.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestar.model.ListTagsForProjectRequest
  ): zio.aws.codestar.model.ListTagsForProjectRequest.ReadOnly = new Wrapper(
    impl
  )
}
