package zio.aws.codestar.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codestar.model.primitives.ClientRequestToken
import scala.jdk.CollectionConverters.*
final case class AssociateTeamMemberResponse(
    clientRequestToken: Option[ClientRequestToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestar.model.AssociateTeamMemberResponse = {
    import AssociateTeamMemberResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestar.model.AssociateTeamMemberResponse
      .builder()
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .build()
  }
  def asReadOnly: zio.aws.codestar.model.AssociateTeamMemberResponse.ReadOnly =
    zio.aws.codestar.model.AssociateTeamMemberResponse.wrap(buildAwsValue())
}
object AssociateTeamMemberResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestar.model.AssociateTeamMemberResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestar.model.AssociateTeamMemberResponse =
      zio.aws.codestar.model
        .AssociateTeamMemberResponse(clientRequestToken.map(value => value))
    def clientRequestToken: Option[ClientRequestToken]
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestar.model.AssociateTeamMemberResponse
  ) extends zio.aws.codestar.model.AssociateTeamMemberResponse.ReadOnly {
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value => zio.aws.codestar.model.primitives.ClientRequestToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestar.model.AssociateTeamMemberResponse
  ): zio.aws.codestar.model.AssociateTeamMemberResponse.ReadOnly = new Wrapper(
    impl
  )
}
