package zio.aws.codestar.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codestar.model.primitives.{MaxResults, PaginationToken}
import scala.jdk.CollectionConverters.*
final case class ListUserProfilesRequest(
    nextToken: Option[PaginationToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestar.model.ListUserProfilesRequest = {
    import ListUserProfilesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestar.model.ListUserProfilesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.codestar.model.ListUserProfilesRequest.ReadOnly =
    zio.aws.codestar.model.ListUserProfilesRequest.wrap(buildAwsValue())
}
object ListUserProfilesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestar.model.ListUserProfilesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestar.model.ListUserProfilesRequest =
      zio.aws.codestar.model.ListUserProfilesRequest(
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def nextToken: Option[PaginationToken]
    def maxResults: Option[MaxResults]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestar.model.ListUserProfilesRequest
  ) extends zio.aws.codestar.model.ListUserProfilesRequest.ReadOnly {
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.codestar.model.primitives.PaginationToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.codestar.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestar.model.ListUserProfilesRequest
  ): zio.aws.codestar.model.ListUserProfilesRequest.ReadOnly = new Wrapper(impl)
}
