package zio.aws.codestar.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codestar.model.primitives.RepositoryName
import scala.jdk.CollectionConverters.*
final case class CodeCommitCodeDestination(name: RepositoryName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestar.model.CodeCommitCodeDestination = {
    import CodeCommitCodeDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestar.model.CodeCommitCodeDestination
      .builder()
      .name(RepositoryName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codestar.model.CodeCommitCodeDestination.ReadOnly =
    zio.aws.codestar.model.CodeCommitCodeDestination.wrap(buildAwsValue())
}
object CodeCommitCodeDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestar.model.CodeCommitCodeDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestar.model.CodeCommitCodeDestination =
      zio.aws.codestar.model.CodeCommitCodeDestination(name)
    def name: RepositoryName
    def getName: ZIO[Any, Nothing, RepositoryName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestar.model.CodeCommitCodeDestination
  ) extends zio.aws.codestar.model.CodeCommitCodeDestination.ReadOnly {
    override val name: RepositoryName =
      zio.aws.codestar.model.primitives.RepositoryName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestar.model.CodeCommitCodeDestination
  ): zio.aws.codestar.model.CodeCommitCodeDestination.ReadOnly = new Wrapper(
    impl
  )
}
