package zio.aws.codestar.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codestar.model.primitives.{
  SshPublicKey,
  Email,
  UserProfileDisplayName,
  UserArn
}
import scala.jdk.CollectionConverters.*
final case class UpdateUserProfileRequest(
    userArn: UserArn,
    displayName: Option[UserProfileDisplayName] = None,
    emailAddress: Option[Email] = None,
    sshPublicKey: Option[SshPublicKey] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestar.model.UpdateUserProfileRequest = {
    import UpdateUserProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestar.model.UpdateUserProfileRequest
      .builder()
      .userArn(UserArn.unwrap(userArn): java.lang.String)
      .optionallyWith(
        displayName.map(value =>
          UserProfileDisplayName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .optionallyWith(
        emailAddress.map(value => Email.unwrap(value): java.lang.String)
      )(_.emailAddress)
      .optionallyWith(
        sshPublicKey.map(value => SshPublicKey.unwrap(value): java.lang.String)
      )(_.sshPublicKey)
      .build()
  }
  def asReadOnly: zio.aws.codestar.model.UpdateUserProfileRequest.ReadOnly =
    zio.aws.codestar.model.UpdateUserProfileRequest.wrap(buildAwsValue())
}
object UpdateUserProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestar.model.UpdateUserProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestar.model.UpdateUserProfileRequest =
      zio.aws.codestar.model.UpdateUserProfileRequest(
        userArn,
        displayName.map(value => value),
        emailAddress.map(value => value),
        sshPublicKey.map(value => value)
      )
    def userArn: UserArn
    def displayName: Option[UserProfileDisplayName]
    def emailAddress: Option[Email]
    def sshPublicKey: Option[SshPublicKey]
    def getUserArn: ZIO[Any, Nothing, UserArn] = ZIO.succeed(userArn)
    def getDisplayName: ZIO[Any, AwsError, UserProfileDisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getEmailAddress: ZIO[Any, AwsError, Email] =
      AwsError.unwrapOptionField("emailAddress", emailAddress)
    def getSshPublicKey: ZIO[Any, AwsError, SshPublicKey] =
      AwsError.unwrapOptionField("sshPublicKey", sshPublicKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestar.model.UpdateUserProfileRequest
  ) extends zio.aws.codestar.model.UpdateUserProfileRequest.ReadOnly {
    override val userArn: UserArn =
      zio.aws.codestar.model.primitives.UserArn(impl.userArn())
    override val displayName: Option[UserProfileDisplayName] = scala
      .Option(impl.displayName())
      .map(value =>
        zio.aws.codestar.model.primitives.UserProfileDisplayName(value)
      )
    override val emailAddress: Option[Email] = scala
      .Option(impl.emailAddress())
      .map(value => zio.aws.codestar.model.primitives.Email(value))
    override val sshPublicKey: Option[SshPublicKey] = scala
      .Option(impl.sshPublicKey())
      .map(value => zio.aws.codestar.model.primitives.SshPublicKey(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestar.model.UpdateUserProfileRequest
  ): zio.aws.codestar.model.UpdateUserProfileRequest.ReadOnly = new Wrapper(
    impl
  )
}
