package zio.aws.codestar.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codestar.model.primitives.{TagKey, ProjectId}
import scala.jdk.CollectionConverters.*
final case class UntagProjectRequest(id: ProjectId, tags: Iterable[TagKey]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestar.model.UntagProjectRequest = {
    import UntagProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestar.model.UntagProjectRequest
      .builder()
      .id(ProjectId.unwrap(id): java.lang.String)
      .tags(tags.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.codestar.model.UntagProjectRequest.ReadOnly =
    zio.aws.codestar.model.UntagProjectRequest.wrap(buildAwsValue())
}
object UntagProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestar.model.UntagProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestar.model.UntagProjectRequest =
      zio.aws.codestar.model.UntagProjectRequest(id, tags)
    def id: ProjectId
    def tags: List[TagKey]
    def getId: ZIO[Any, Nothing, ProjectId] = ZIO.succeed(id)
    def getTags: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestar.model.UntagProjectRequest
  ) extends zio.aws.codestar.model.UntagProjectRequest.ReadOnly {
    override val id: ProjectId =
      zio.aws.codestar.model.primitives.ProjectId(impl.id())
    override val tags: List[TagKey] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.codestar.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestar.model.UntagProjectRequest
  ): zio.aws.codestar.model.UntagProjectRequest.ReadOnly = new Wrapper(impl)
}
