package zio.aws.codestar.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codestar.model.primitives.PaginationToken
import scala.jdk.CollectionConverters.*
final case class ListResourcesResponse(
    resources: Option[Iterable[zio.aws.codestar.model.Resource]] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestar.model.ListResourcesResponse = {
    import ListResourcesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestar.model.ListResourcesResponse
      .builder()
      .optionallyWith(
        resources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resources)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.codestar.model.ListResourcesResponse.ReadOnly =
    zio.aws.codestar.model.ListResourcesResponse.wrap(buildAwsValue())
}
object ListResourcesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestar.model.ListResourcesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestar.model.ListResourcesResponse =
      zio.aws.codestar.model.ListResourcesResponse(
        resources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def resources: Option[List[zio.aws.codestar.model.Resource.ReadOnly]]
    def nextToken: Option[PaginationToken]
    def getResources
        : ZIO[Any, AwsError, List[zio.aws.codestar.model.Resource.ReadOnly]] =
      AwsError.unwrapOptionField("resources", resources)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestar.model.ListResourcesResponse
  ) extends zio.aws.codestar.model.ListResourcesResponse.ReadOnly {
    override val resources
        : Option[List[zio.aws.codestar.model.Resource.ReadOnly]] = scala
      .Option(impl.resources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codestar.model.Resource.wrap(item)
        }.toList
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.codestar.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestar.model.ListResourcesResponse
  ): zio.aws.codestar.model.ListResourcesResponse.ReadOnly = new Wrapper(impl)
}
