package zio.aws.codestar.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codestar.model.primitives.{BucketKey, BucketName}
import scala.jdk.CollectionConverters.*
final case class S3Location(
    bucketName: Option[BucketName] = None,
    bucketKey: Option[BucketKey] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestar.model.S3Location = {
    import S3Location.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestar.model.S3Location
      .builder()
      .optionallyWith(
        bucketName.map(value => BucketName.unwrap(value): java.lang.String)
      )(_.bucketName)
      .optionallyWith(
        bucketKey.map(value => BucketKey.unwrap(value): java.lang.String)
      )(_.bucketKey)
      .build()
  }
  def asReadOnly: zio.aws.codestar.model.S3Location.ReadOnly =
    zio.aws.codestar.model.S3Location.wrap(buildAwsValue())
}
object S3Location {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestar.model.S3Location
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestar.model.S3Location = zio.aws.codestar.model
      .S3Location(bucketName.map(value => value), bucketKey.map(value => value))
    def bucketName: Option[BucketName]
    def bucketKey: Option[BucketKey]
    def getBucketName: ZIO[Any, AwsError, BucketName] =
      AwsError.unwrapOptionField("bucketName", bucketName)
    def getBucketKey: ZIO[Any, AwsError, BucketKey] =
      AwsError.unwrapOptionField("bucketKey", bucketKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestar.model.S3Location
  ) extends zio.aws.codestar.model.S3Location.ReadOnly {
    override val bucketName: Option[BucketName] = scala
      .Option(impl.bucketName())
      .map(value => zio.aws.codestar.model.primitives.BucketName(value))
    override val bucketKey: Option[BucketKey] = scala
      .Option(impl.bucketKey())
      .map(value => zio.aws.codestar.model.primitives.BucketKey(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestar.model.S3Location
  ): zio.aws.codestar.model.S3Location.ReadOnly = new Wrapper(impl)
}
