package zio.aws.codestar.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codestar.model.primitives.{RemoteAccessAllowed, Role, UserArn}
import scala.jdk.CollectionConverters.*
final case class UpdateTeamMemberResponse(
    userArn: Option[UserArn] = None,
    projectRole: Option[Role] = None,
    remoteAccessAllowed: Option[RemoteAccessAllowed] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestar.model.UpdateTeamMemberResponse = {
    import UpdateTeamMemberResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestar.model.UpdateTeamMemberResponse
      .builder()
      .optionallyWith(
        userArn.map(value => UserArn.unwrap(value): java.lang.String)
      )(_.userArn)
      .optionallyWith(
        projectRole.map(value => Role.unwrap(value): java.lang.String)
      )(_.projectRole)
      .optionallyWith(
        remoteAccessAllowed.map(value =>
          RemoteAccessAllowed.unwrap(value): java.lang.Boolean
        )
      )(_.remoteAccessAllowed)
      .build()
  }
  def asReadOnly: zio.aws.codestar.model.UpdateTeamMemberResponse.ReadOnly =
    zio.aws.codestar.model.UpdateTeamMemberResponse.wrap(buildAwsValue())
}
object UpdateTeamMemberResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestar.model.UpdateTeamMemberResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestar.model.UpdateTeamMemberResponse =
      zio.aws.codestar.model.UpdateTeamMemberResponse(
        userArn.map(value => value),
        projectRole.map(value => value),
        remoteAccessAllowed.map(value => value)
      )
    def userArn: Option[UserArn]
    def projectRole: Option[Role]
    def remoteAccessAllowed: Option[RemoteAccessAllowed]
    def getUserArn: ZIO[Any, AwsError, UserArn] =
      AwsError.unwrapOptionField("userArn", userArn)
    def getProjectRole: ZIO[Any, AwsError, Role] =
      AwsError.unwrapOptionField("projectRole", projectRole)
    def getRemoteAccessAllowed: ZIO[Any, AwsError, RemoteAccessAllowed] =
      AwsError.unwrapOptionField("remoteAccessAllowed", remoteAccessAllowed)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestar.model.UpdateTeamMemberResponse
  ) extends zio.aws.codestar.model.UpdateTeamMemberResponse.ReadOnly {
    override val userArn: Option[UserArn] = scala
      .Option(impl.userArn())
      .map(value => zio.aws.codestar.model.primitives.UserArn(value))
    override val projectRole: Option[Role] = scala
      .Option(impl.projectRole())
      .map(value => zio.aws.codestar.model.primitives.Role(value))
    override val remoteAccessAllowed: Option[RemoteAccessAllowed] = scala
      .Option(impl.remoteAccessAllowed())
      .map(value =>
        zio.aws.codestar.model.primitives.RemoteAccessAllowed(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestar.model.UpdateTeamMemberResponse
  ): zio.aws.codestar.model.UpdateTeamMemberResponse.ReadOnly = new Wrapper(
    impl
  )
}
