package zio.aws.codestar.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CodeSource(s3: zio.aws.codestar.model.S3Location) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestar.model.CodeSource = {
    import CodeSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestar.model.CodeSource
      .builder()
      .s3(s3.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.codestar.model.CodeSource.ReadOnly =
    zio.aws.codestar.model.CodeSource.wrap(buildAwsValue())
}
object CodeSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestar.model.CodeSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestar.model.CodeSource =
      zio.aws.codestar.model.CodeSource(s3.asEditable)
    def s3: zio.aws.codestar.model.S3Location.ReadOnly
    def getS3: ZIO[Any, Nothing, zio.aws.codestar.model.S3Location.ReadOnly] =
      ZIO.succeed(s3)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestar.model.CodeSource
  ) extends zio.aws.codestar.model.CodeSource.ReadOnly {
    override val s3: zio.aws.codestar.model.S3Location.ReadOnly =
      zio.aws.codestar.model.S3Location.wrap(impl.s3())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestar.model.CodeSource
  ): zio.aws.codestar.model.CodeSource.ReadOnly = new Wrapper(impl)
}
