package zio.aws.codestar.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codestar.model.primitives.{ProjectArn, ProjectId}
import scala.jdk.CollectionConverters.*
final case class ProjectSummary(
    projectId: Option[ProjectId] = None,
    projectArn: Option[ProjectArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestar.model.ProjectSummary = {
    import ProjectSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestar.model.ProjectSummary
      .builder()
      .optionallyWith(
        projectId.map(value => ProjectId.unwrap(value): java.lang.String)
      )(_.projectId)
      .optionallyWith(
        projectArn.map(value => ProjectArn.unwrap(value): java.lang.String)
      )(_.projectArn)
      .build()
  }
  def asReadOnly: zio.aws.codestar.model.ProjectSummary.ReadOnly =
    zio.aws.codestar.model.ProjectSummary.wrap(buildAwsValue())
}
object ProjectSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestar.model.ProjectSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestar.model.ProjectSummary =
      zio.aws.codestar.model.ProjectSummary(
        projectId.map(value => value),
        projectArn.map(value => value)
      )
    def projectId: Option[ProjectId]
    def projectArn: Option[ProjectArn]
    def getProjectId: ZIO[Any, AwsError, ProjectId] =
      AwsError.unwrapOptionField("projectId", projectId)
    def getProjectArn: ZIO[Any, AwsError, ProjectArn] =
      AwsError.unwrapOptionField("projectArn", projectArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestar.model.ProjectSummary
  ) extends zio.aws.codestar.model.ProjectSummary.ReadOnly {
    override val projectId: Option[ProjectId] = scala
      .Option(impl.projectId())
      .map(value => zio.aws.codestar.model.primitives.ProjectId(value))
    override val projectArn: Option[ProjectArn] = scala
      .Option(impl.projectArn())
      .map(value => zio.aws.codestar.model.primitives.ProjectArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestar.model.ProjectSummary
  ): zio.aws.codestar.model.ProjectSummary.ReadOnly = new Wrapper(impl)
}
