package zio.aws.codestar
import zio.aws.codestar.model.TagProjectResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import zio.aws.codestar.model.{
  ListUserProfilesRequest,
  CreateProjectRequest,
  TagProjectRequest,
  UpdateTeamMemberRequest,
  UpdateProjectRequest,
  AssociateTeamMemberRequest,
  DeleteProjectRequest,
  ListResourcesRequest,
  UntagProjectRequest,
  DisassociateTeamMemberRequest,
  ListProjectsRequest,
  DeleteUserProfileRequest,
  DescribeUserProfileRequest,
  ListTagsForProjectRequest,
  ListTeamMembersRequest,
  DescribeProjectRequest,
  CreateUserProfileRequest,
  UpdateUserProfileRequest
}
import software.amazon.awssdk.services.codestar.model.{
  DescribeProjectResponse,
  ListTeamMembersResponse,
  DescribeUserProfileResponse,
  ListProjectsResponse,
  ListResourcesResponse,
  ListUserProfilesResponse,
  CreateProjectResponse,
  ListTagsForProjectResponse,
  DisassociateTeamMemberResponse,
  UpdateUserProfileResponse,
  CreateUserProfileResponse,
  AssociateTeamMemberResponse,
  UntagProjectResponse,
  TagProjectResponse,
  UpdateProjectResponse,
  UpdateTeamMemberResponse,
  DeleteProjectResponse,
  DeleteUserProfileResponse
}
import software.amazon.awssdk.services.codestar.{
  CodeStarAsyncClientBuilder,
  CodeStarAsyncClient
}
import scala.jdk.CollectionConverters.*
trait CodeStar extends AspectSupport[CodeStar] {
  val api: CodeStarAsyncClient
  def listTeamMembers(
      request: ListTeamMembersRequest
  ): IO[AwsError, zio.aws.codestar.model.ListTeamMembersResponse.ReadOnly]
  def listUserProfiles(
      request: ListUserProfilesRequest
  ): IO[AwsError, zio.aws.codestar.model.ListUserProfilesResponse.ReadOnly]
  def updateProject(
      request: UpdateProjectRequest
  ): IO[AwsError, zio.aws.codestar.model.UpdateProjectResponse.ReadOnly]
  def tagProject(request: TagProjectRequest): IO[AwsError, ReadOnly]
  def updateUserProfile(
      request: UpdateUserProfileRequest
  ): IO[AwsError, zio.aws.codestar.model.UpdateUserProfileResponse.ReadOnly]
  def listProjects(
      request: ListProjectsRequest
  ): IO[AwsError, zio.aws.codestar.model.ListProjectsResponse.ReadOnly]
  def updateTeamMember(
      request: UpdateTeamMemberRequest
  ): IO[AwsError, zio.aws.codestar.model.UpdateTeamMemberResponse.ReadOnly]
  def createProject(
      request: CreateProjectRequest
  ): IO[AwsError, zio.aws.codestar.model.CreateProjectResponse.ReadOnly]
  def listResources(
      request: ListResourcesRequest
  ): IO[AwsError, zio.aws.codestar.model.ListResourcesResponse.ReadOnly]
  def listTagsForProject(
      request: ListTagsForProjectRequest
  ): IO[AwsError, zio.aws.codestar.model.ListTagsForProjectResponse.ReadOnly]
  def describeProject(
      request: DescribeProjectRequest
  ): IO[AwsError, zio.aws.codestar.model.DescribeProjectResponse.ReadOnly]
  def describeUserProfile(
      request: DescribeUserProfileRequest
  ): IO[AwsError, zio.aws.codestar.model.DescribeUserProfileResponse.ReadOnly]
  def deleteUserProfile(
      request: DeleteUserProfileRequest
  ): IO[AwsError, zio.aws.codestar.model.DeleteUserProfileResponse.ReadOnly]
  def deleteProject(
      request: DeleteProjectRequest
  ): IO[AwsError, zio.aws.codestar.model.DeleteProjectResponse.ReadOnly]
  def untagProject(
      request: UntagProjectRequest
  ): IO[AwsError, zio.aws.codestar.model.UntagProjectResponse.ReadOnly]
  def createUserProfile(
      request: CreateUserProfileRequest
  ): IO[AwsError, zio.aws.codestar.model.CreateUserProfileResponse.ReadOnly]
  def disassociateTeamMember(request: DisassociateTeamMemberRequest): IO[
    AwsError,
    zio.aws.codestar.model.DisassociateTeamMemberResponse.ReadOnly
  ]
  def associateTeamMember(
      request: AssociateTeamMemberRequest
  ): IO[AwsError, zio.aws.codestar.model.AssociateTeamMemberResponse.ReadOnly]
}
object CodeStar {
  val live: ZLayer[AwsConfig, java.lang.Throwable, CodeStar] = customized(
    identity
  )
  def customized(
      customization: CodeStarAsyncClientBuilder => CodeStarAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, CodeStar] = managed(
    customization
  ).toLayer
  def managed(
      customization: CodeStarAsyncClientBuilder => CodeStarAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, CodeStar] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = CodeStarAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[CodeStarAsyncClient, CodeStarAsyncClientBuilder](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[CodeStarAsyncClient, CodeStarAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  ) yield new CodeStarImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class CodeStarImpl[R](
      override val api: CodeStarAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends CodeStar
      with AwsServiceBase[R] {
    override val serviceName: String = "CodeStar"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): CodeStarImpl[R1] = new CodeStarImpl(api, newAspect, r)
    def listTeamMembers(
        request: ListTeamMembersRequest
    ): IO[AwsError, zio.aws.codestar.model.ListTeamMembersResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.codestar.model.ListTeamMembersRequest,
        ListTeamMembersResponse
      ]("listTeamMembers", api.listTeamMembers)(request.buildAwsValue())
        .map(zio.aws.codestar.model.ListTeamMembersResponse.wrap)
        .provideEnvironment(r)
    def listUserProfiles(
        request: ListUserProfilesRequest
    ): IO[AwsError, zio.aws.codestar.model.ListUserProfilesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.codestar.model.ListUserProfilesRequest,
        ListUserProfilesResponse
      ]("listUserProfiles", api.listUserProfiles)(request.buildAwsValue())
        .map(zio.aws.codestar.model.ListUserProfilesResponse.wrap)
        .provideEnvironment(r)
    def updateProject(
        request: UpdateProjectRequest
    ): IO[AwsError, zio.aws.codestar.model.UpdateProjectResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.codestar.model.UpdateProjectRequest,
        UpdateProjectResponse
      ]("updateProject", api.updateProject)(request.buildAwsValue())
        .map(zio.aws.codestar.model.UpdateProjectResponse.wrap)
        .provideEnvironment(r)
    def tagProject(request: TagProjectRequest): IO[AwsError, ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.codestar.model.TagProjectRequest,
        TagProjectResponse
      ]("tagProject", api.tagProject)(request.buildAwsValue())
        .map(zio.aws.codestar.model.TagProjectResponse.wrap)
        .provideEnvironment(r)
    def updateUserProfile(
        request: UpdateUserProfileRequest
    ): IO[AwsError, zio.aws.codestar.model.UpdateUserProfileResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.codestar.model.UpdateUserProfileRequest,
        UpdateUserProfileResponse
      ]("updateUserProfile", api.updateUserProfile)(request.buildAwsValue())
        .map(zio.aws.codestar.model.UpdateUserProfileResponse.wrap)
        .provideEnvironment(r)
    def listProjects(
        request: ListProjectsRequest
    ): IO[AwsError, zio.aws.codestar.model.ListProjectsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.codestar.model.ListProjectsRequest,
        ListProjectsResponse
      ]("listProjects", api.listProjects)(request.buildAwsValue())
        .map(zio.aws.codestar.model.ListProjectsResponse.wrap)
        .provideEnvironment(r)
    def updateTeamMember(
        request: UpdateTeamMemberRequest
    ): IO[AwsError, zio.aws.codestar.model.UpdateTeamMemberResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.codestar.model.UpdateTeamMemberRequest,
        UpdateTeamMemberResponse
      ]("updateTeamMember", api.updateTeamMember)(request.buildAwsValue())
        .map(zio.aws.codestar.model.UpdateTeamMemberResponse.wrap)
        .provideEnvironment(r)
    def createProject(
        request: CreateProjectRequest
    ): IO[AwsError, zio.aws.codestar.model.CreateProjectResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.codestar.model.CreateProjectRequest,
        CreateProjectResponse
      ]("createProject", api.createProject)(request.buildAwsValue())
        .map(zio.aws.codestar.model.CreateProjectResponse.wrap)
        .provideEnvironment(r)
    def listResources(
        request: ListResourcesRequest
    ): IO[AwsError, zio.aws.codestar.model.ListResourcesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.codestar.model.ListResourcesRequest,
        ListResourcesResponse
      ]("listResources", api.listResources)(request.buildAwsValue())
        .map(zio.aws.codestar.model.ListResourcesResponse.wrap)
        .provideEnvironment(r)
    def listTagsForProject(request: ListTagsForProjectRequest): IO[
      AwsError,
      zio.aws.codestar.model.ListTagsForProjectResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codestar.model.ListTagsForProjectRequest,
      ListTagsForProjectResponse
    ]("listTagsForProject", api.listTagsForProject)(request.buildAwsValue())
      .map(zio.aws.codestar.model.ListTagsForProjectResponse.wrap)
      .provideEnvironment(r)
    def describeProject(
        request: DescribeProjectRequest
    ): IO[AwsError, zio.aws.codestar.model.DescribeProjectResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.codestar.model.DescribeProjectRequest,
        DescribeProjectResponse
      ]("describeProject", api.describeProject)(request.buildAwsValue())
        .map(zio.aws.codestar.model.DescribeProjectResponse.wrap)
        .provideEnvironment(r)
    def describeUserProfile(request: DescribeUserProfileRequest): IO[
      AwsError,
      zio.aws.codestar.model.DescribeUserProfileResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codestar.model.DescribeUserProfileRequest,
      DescribeUserProfileResponse
    ]("describeUserProfile", api.describeUserProfile)(request.buildAwsValue())
      .map(zio.aws.codestar.model.DescribeUserProfileResponse.wrap)
      .provideEnvironment(r)
    def deleteUserProfile(
        request: DeleteUserProfileRequest
    ): IO[AwsError, zio.aws.codestar.model.DeleteUserProfileResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.codestar.model.DeleteUserProfileRequest,
        DeleteUserProfileResponse
      ]("deleteUserProfile", api.deleteUserProfile)(request.buildAwsValue())
        .map(zio.aws.codestar.model.DeleteUserProfileResponse.wrap)
        .provideEnvironment(r)
    def deleteProject(
        request: DeleteProjectRequest
    ): IO[AwsError, zio.aws.codestar.model.DeleteProjectResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.codestar.model.DeleteProjectRequest,
        DeleteProjectResponse
      ]("deleteProject", api.deleteProject)(request.buildAwsValue())
        .map(zio.aws.codestar.model.DeleteProjectResponse.wrap)
        .provideEnvironment(r)
    def untagProject(
        request: UntagProjectRequest
    ): IO[AwsError, zio.aws.codestar.model.UntagProjectResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.codestar.model.UntagProjectRequest,
        UntagProjectResponse
      ]("untagProject", api.untagProject)(request.buildAwsValue())
        .map(zio.aws.codestar.model.UntagProjectResponse.wrap)
        .provideEnvironment(r)
    def createUserProfile(
        request: CreateUserProfileRequest
    ): IO[AwsError, zio.aws.codestar.model.CreateUserProfileResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.codestar.model.CreateUserProfileRequest,
        CreateUserProfileResponse
      ]("createUserProfile", api.createUserProfile)(request.buildAwsValue())
        .map(zio.aws.codestar.model.CreateUserProfileResponse.wrap)
        .provideEnvironment(r)
    def disassociateTeamMember(request: DisassociateTeamMemberRequest): IO[
      AwsError,
      zio.aws.codestar.model.DisassociateTeamMemberResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codestar.model.DisassociateTeamMemberRequest,
      DisassociateTeamMemberResponse
    ]("disassociateTeamMember", api.disassociateTeamMember)(
      request.buildAwsValue()
    ).map(zio.aws.codestar.model.DisassociateTeamMemberResponse.wrap)
      .provideEnvironment(r)
    def associateTeamMember(request: AssociateTeamMemberRequest): IO[
      AwsError,
      zio.aws.codestar.model.AssociateTeamMemberResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.codestar.model.AssociateTeamMemberRequest,
      AssociateTeamMemberResponse
    ]("associateTeamMember", api.associateTeamMember)(request.buildAwsValue())
      .map(zio.aws.codestar.model.AssociateTeamMemberResponse.wrap)
      .provideEnvironment(r)
  }
  def listTeamMembers(request: ListTeamMembersRequest): ZIO[
    zio.aws.codestar.CodeStar,
    AwsError,
    zio.aws.codestar.model.ListTeamMembersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTeamMembers(request))
  def listUserProfiles(request: ListUserProfilesRequest): ZIO[
    zio.aws.codestar.CodeStar,
    AwsError,
    zio.aws.codestar.model.ListUserProfilesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listUserProfiles(request))
  def updateProject(request: UpdateProjectRequest): ZIO[
    zio.aws.codestar.CodeStar,
    AwsError,
    zio.aws.codestar.model.UpdateProjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateProject(request))
  def tagProject(
      request: TagProjectRequest
  ): ZIO[zio.aws.codestar.CodeStar, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.tagProject(request))
  def updateUserProfile(request: UpdateUserProfileRequest): ZIO[
    zio.aws.codestar.CodeStar,
    AwsError,
    zio.aws.codestar.model.UpdateUserProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateUserProfile(request))
  def listProjects(request: ListProjectsRequest): ZIO[
    zio.aws.codestar.CodeStar,
    AwsError,
    zio.aws.codestar.model.ListProjectsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listProjects(request))
  def updateTeamMember(request: UpdateTeamMemberRequest): ZIO[
    zio.aws.codestar.CodeStar,
    AwsError,
    zio.aws.codestar.model.UpdateTeamMemberResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateTeamMember(request))
  def createProject(request: CreateProjectRequest): ZIO[
    zio.aws.codestar.CodeStar,
    AwsError,
    zio.aws.codestar.model.CreateProjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createProject(request))
  def listResources(request: ListResourcesRequest): ZIO[
    zio.aws.codestar.CodeStar,
    AwsError,
    zio.aws.codestar.model.ListResourcesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listResources(request))
  def listTagsForProject(request: ListTagsForProjectRequest): ZIO[
    zio.aws.codestar.CodeStar,
    AwsError,
    zio.aws.codestar.model.ListTagsForProjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForProject(request))
  def describeProject(request: DescribeProjectRequest): ZIO[
    zio.aws.codestar.CodeStar,
    AwsError,
    zio.aws.codestar.model.DescribeProjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeProject(request))
  def describeUserProfile(request: DescribeUserProfileRequest): ZIO[
    zio.aws.codestar.CodeStar,
    AwsError,
    zio.aws.codestar.model.DescribeUserProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeUserProfile(request))
  def deleteUserProfile(request: DeleteUserProfileRequest): ZIO[
    zio.aws.codestar.CodeStar,
    AwsError,
    zio.aws.codestar.model.DeleteUserProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteUserProfile(request))
  def deleteProject(request: DeleteProjectRequest): ZIO[
    zio.aws.codestar.CodeStar,
    AwsError,
    zio.aws.codestar.model.DeleteProjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteProject(request))
  def untagProject(request: UntagProjectRequest): ZIO[
    zio.aws.codestar.CodeStar,
    AwsError,
    zio.aws.codestar.model.UntagProjectResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagProject(request))
  def createUserProfile(request: CreateUserProfileRequest): ZIO[
    zio.aws.codestar.CodeStar,
    AwsError,
    zio.aws.codestar.model.CreateUserProfileResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createUserProfile(request))
  def disassociateTeamMember(request: DisassociateTeamMemberRequest): ZIO[
    zio.aws.codestar.CodeStar,
    AwsError,
    zio.aws.codestar.model.DisassociateTeamMemberResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateTeamMember(request))
  def associateTeamMember(request: AssociateTeamMemberRequest): ZIO[
    zio.aws.codestar.CodeStar,
    AwsError,
    zio.aws.codestar.model.AssociateTeamMemberResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateTeamMember(request))
}
