package zio.aws.codestar.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.codestar.model.primitives.{
  SshPublicKey,
  Email,
  UserProfileDisplayName,
  UserArn
}
import scala.jdk.CollectionConverters._
final case class CreateUserProfileRequest(
    userArn: UserArn,
    displayName: UserProfileDisplayName,
    emailAddress: Email,
    sshPublicKey: Optional[SshPublicKey] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestar.model.CreateUserProfileRequest = {
    import CreateUserProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestar.model.CreateUserProfileRequest
      .builder()
      .userArn(UserArn.unwrap(userArn): java.lang.String)
      .displayName(UserProfileDisplayName.unwrap(displayName): java.lang.String)
      .emailAddress(Email.unwrap(emailAddress): java.lang.String)
      .optionallyWith(
        sshPublicKey.map(value => SshPublicKey.unwrap(value): java.lang.String)
      )(_.sshPublicKey)
      .build()
  }
  def asReadOnly: zio.aws.codestar.model.CreateUserProfileRequest.ReadOnly =
    zio.aws.codestar.model.CreateUserProfileRequest.wrap(buildAwsValue())
}
object CreateUserProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestar.model.CreateUserProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestar.model.CreateUserProfileRequest =
      zio.aws.codestar.model.CreateUserProfileRequest(
        userArn,
        displayName,
        emailAddress,
        sshPublicKey.map(value => value)
      )
    def userArn: UserArn
    def displayName: UserProfileDisplayName
    def emailAddress: Email
    def sshPublicKey: Optional[SshPublicKey]
    def getUserArn: ZIO[Any, Nothing, UserArn] = ZIO.succeed(userArn)
    def getDisplayName: ZIO[Any, Nothing, UserProfileDisplayName] =
      ZIO.succeed(displayName)
    def getEmailAddress: ZIO[Any, Nothing, Email] = ZIO.succeed(emailAddress)
    def getSshPublicKey: ZIO[Any, AwsError, SshPublicKey] =
      AwsError.unwrapOptionField("sshPublicKey", sshPublicKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestar.model.CreateUserProfileRequest
  ) extends zio.aws.codestar.model.CreateUserProfileRequest.ReadOnly {
    override val userArn: UserArn =
      zio.aws.codestar.model.primitives.UserArn(impl.userArn())
    override val displayName: UserProfileDisplayName =
      zio.aws.codestar.model.primitives
        .UserProfileDisplayName(impl.displayName())
    override val emailAddress: Email =
      zio.aws.codestar.model.primitives.Email(impl.emailAddress())
    override val sshPublicKey: Optional[SshPublicKey] = zio.aws.core.internal
      .optionalFromNullable(impl.sshPublicKey())
      .map(value => zio.aws.codestar.model.primitives.SshPublicKey(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestar.model.CreateUserProfileRequest
  ): zio.aws.codestar.model.CreateUserProfileRequest.ReadOnly = new Wrapper(
    impl
  )
}
