package zio.aws.codestar.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.codestar.model.primitives.UserArn
import scala.jdk.CollectionConverters._
final case class DeleteUserProfileRequest(userArn: UserArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestar.model.DeleteUserProfileRequest = {
    import DeleteUserProfileRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestar.model.DeleteUserProfileRequest
      .builder()
      .userArn(UserArn.unwrap(userArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codestar.model.DeleteUserProfileRequest.ReadOnly =
    zio.aws.codestar.model.DeleteUserProfileRequest.wrap(buildAwsValue())
}
object DeleteUserProfileRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestar.model.DeleteUserProfileRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestar.model.DeleteUserProfileRequest =
      zio.aws.codestar.model.DeleteUserProfileRequest(userArn)
    def userArn: UserArn
    def getUserArn: ZIO[Any, Nothing, UserArn] = ZIO.succeed(userArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestar.model.DeleteUserProfileRequest
  ) extends zio.aws.codestar.model.DeleteUserProfileRequest.ReadOnly {
    override val userArn: UserArn =
      zio.aws.codestar.model.primitives.UserArn(impl.userArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestar.model.DeleteUserProfileRequest
  ): zio.aws.codestar.model.DeleteUserProfileRequest.ReadOnly = new Wrapper(
    impl
  )
}
