package zio.aws.codestar.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.codestar.model.primitives.{
  UserArn,
  SshPublicKey,
  UserProfileDisplayName,
  CreatedTimestamp,
  Email,
  LastModifiedTimestamp
}
import scala.jdk.CollectionConverters._
final case class CreateUserProfileResponse(
    userArn: UserArn,
    displayName: Option[UserProfileDisplayName] = None,
    emailAddress: Option[Email] = None,
    sshPublicKey: Option[SshPublicKey] = None,
    createdTimestamp: Option[CreatedTimestamp] = None,
    lastModifiedTimestamp: Option[LastModifiedTimestamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestar.model.CreateUserProfileResponse = {
    import CreateUserProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestar.model.CreateUserProfileResponse
      .builder()
      .userArn(UserArn.unwrap(userArn): java.lang.String)
      .optionallyWith(
        displayName.map(value =>
          UserProfileDisplayName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .optionallyWith(
        emailAddress.map(value => Email.unwrap(value): java.lang.String)
      )(_.emailAddress)
      .optionallyWith(
        sshPublicKey.map(value => SshPublicKey.unwrap(value): java.lang.String)
      )(_.sshPublicKey)
      .optionallyWith(
        createdTimestamp.map(value => CreatedTimestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        lastModifiedTimestamp.map(value =>
          LastModifiedTimestamp.unwrap(value): Instant
        )
      )(_.lastModifiedTimestamp)
      .build()
  }
  def asReadOnly: zio.aws.codestar.model.CreateUserProfileResponse.ReadOnly =
    zio.aws.codestar.model.CreateUserProfileResponse.wrap(buildAwsValue())
}
object CreateUserProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestar.model.CreateUserProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestar.model.CreateUserProfileResponse =
      zio.aws.codestar.model.CreateUserProfileResponse(
        userArn,
        displayName.map(value => value),
        emailAddress.map(value => value),
        sshPublicKey.map(value => value),
        createdTimestamp.map(value => value),
        lastModifiedTimestamp.map(value => value)
      )
    def userArn: UserArn
    def displayName: Option[UserProfileDisplayName]
    def emailAddress: Option[Email]
    def sshPublicKey: Option[SshPublicKey]
    def createdTimestamp: Option[CreatedTimestamp]
    def lastModifiedTimestamp: Option[LastModifiedTimestamp]
    def getUserArn: ZIO[Any, Nothing, UserArn] = ZIO.succeed(userArn)
    def getDisplayName: ZIO[Any, AwsError, UserProfileDisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getEmailAddress: ZIO[Any, AwsError, Email] =
      AwsError.unwrapOptionField("emailAddress", emailAddress)
    def getSshPublicKey: ZIO[Any, AwsError, SshPublicKey] =
      AwsError.unwrapOptionField("sshPublicKey", sshPublicKey)
    def getCreatedTimestamp: ZIO[Any, AwsError, CreatedTimestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getLastModifiedTimestamp: ZIO[Any, AwsError, LastModifiedTimestamp] =
      AwsError.unwrapOptionField("lastModifiedTimestamp", lastModifiedTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestar.model.CreateUserProfileResponse
  ) extends zio.aws.codestar.model.CreateUserProfileResponse.ReadOnly {
    override val userArn: UserArn =
      zio.aws.codestar.model.primitives.UserArn(impl.userArn())
    override val displayName: Option[UserProfileDisplayName] = scala
      .Option(impl.displayName())
      .map(value =>
        zio.aws.codestar.model.primitives.UserProfileDisplayName(value)
      )
    override val emailAddress: Option[Email] = scala
      .Option(impl.emailAddress())
      .map(value => zio.aws.codestar.model.primitives.Email(value))
    override val sshPublicKey: Option[SshPublicKey] = scala
      .Option(impl.sshPublicKey())
      .map(value => zio.aws.codestar.model.primitives.SshPublicKey(value))
    override val createdTimestamp: Option[CreatedTimestamp] = scala
      .Option(impl.createdTimestamp())
      .map(value => zio.aws.codestar.model.primitives.CreatedTimestamp(value))
    override val lastModifiedTimestamp: Option[LastModifiedTimestamp] = scala
      .Option(impl.lastModifiedTimestamp())
      .map(value =>
        zio.aws.codestar.model.primitives.LastModifiedTimestamp(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestar.model.CreateUserProfileResponse
  ): zio.aws.codestar.model.CreateUserProfileResponse.ReadOnly = new Wrapper(
    impl
  )
}
