package zio.aws.codestar.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codestar.model.primitives.{PaginationToken, TagValue, TagKey}
import scala.jdk.CollectionConverters._
final case class ListTagsForProjectResponse(
    tags: Option[Map[TagKey, TagValue]] = None,
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestar.model.ListTagsForProjectResponse = {
    import ListTagsForProjectResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestar.model.ListTagsForProjectResponse
      .builder()
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.codestar.model.ListTagsForProjectResponse.ReadOnly =
    zio.aws.codestar.model.ListTagsForProjectResponse.wrap(buildAwsValue())
}
object ListTagsForProjectResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestar.model.ListTagsForProjectResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestar.model.ListTagsForProjectResponse =
      zio.aws.codestar.model.ListTagsForProjectResponse(
        tags.map(value => value),
        nextToken.map(value => value)
      )
    def tags: Option[Map[TagKey, TagValue]]
    def nextToken: Option[PaginationToken]
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestar.model.ListTagsForProjectResponse
  ) extends zio.aws.codestar.model.ListTagsForProjectResponse.ReadOnly {
    override val tags: Option[Map[TagKey, TagValue]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.codestar.model.primitives
              .TagKey(key) -> zio.aws.codestar.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.codestar.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestar.model.ListTagsForProjectResponse
  ): zio.aws.codestar.model.ListTagsForProjectResponse.ReadOnly = new Wrapper(
    impl
  )
}
