package zio.aws.codestar.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codestar.model.primitives.{Reason, State}
import scala.jdk.CollectionConverters._
final case class ProjectStatus(state: State, reason: Option[Reason] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestar.model.ProjectStatus = {
    import ProjectStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestar.model.ProjectStatus
      .builder()
      .state(State.unwrap(state): java.lang.String)
      .optionallyWith(
        reason.map(value => Reason.unwrap(value): java.lang.String)
      )(_.reason)
      .build()
  }
  def asReadOnly: zio.aws.codestar.model.ProjectStatus.ReadOnly =
    zio.aws.codestar.model.ProjectStatus.wrap(buildAwsValue())
}
object ProjectStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestar.model.ProjectStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestar.model.ProjectStatus =
      zio.aws.codestar.model.ProjectStatus(state, reason.map(value => value))
    def state: State
    def reason: Option[Reason]
    def getState: ZIO[Any, Nothing, State] = ZIO.succeed(state)
    def getReason: ZIO[Any, AwsError, Reason] =
      AwsError.unwrapOptionField("reason", reason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestar.model.ProjectStatus
  ) extends zio.aws.codestar.model.ProjectStatus.ReadOnly {
    override val state: State =
      zio.aws.codestar.model.primitives.State(impl.state())
    override val reason: Option[Reason] = scala
      .Option(impl.reason())
      .map(value => zio.aws.codestar.model.primitives.Reason(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestar.model.ProjectStatus
  ): zio.aws.codestar.model.ProjectStatus.ReadOnly = new Wrapper(impl)
}
