package zio.aws.codestar.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codestar.model.primitives.PaginationToken
import scala.jdk.CollectionConverters._
final case class ListTeamMembersResponse(
    teamMembers: Iterable[zio.aws.codestar.model.TeamMember],
    nextToken: Option[PaginationToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestar.model.ListTeamMembersResponse = {
    import ListTeamMembersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestar.model.ListTeamMembersResponse
      .builder()
      .teamMembers(teamMembers.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.codestar.model.ListTeamMembersResponse.ReadOnly =
    zio.aws.codestar.model.ListTeamMembersResponse.wrap(buildAwsValue())
}
object ListTeamMembersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestar.model.ListTeamMembersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestar.model.ListTeamMembersResponse =
      zio.aws.codestar.model.ListTeamMembersResponse(
        teamMembers.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def teamMembers: List[zio.aws.codestar.model.TeamMember.ReadOnly]
    def nextToken: Option[PaginationToken]
    def getTeamMembers
        : ZIO[Any, Nothing, List[zio.aws.codestar.model.TeamMember.ReadOnly]] =
      ZIO.succeed(teamMembers)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestar.model.ListTeamMembersResponse
  ) extends zio.aws.codestar.model.ListTeamMembersResponse.ReadOnly {
    override val teamMembers: List[zio.aws.codestar.model.TeamMember.ReadOnly] =
      impl
        .teamMembers()
        .asScala
        .map { item =>
          zio.aws.codestar.model.TeamMember.wrap(item)
        }
        .toList
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.codestar.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestar.model.ListTeamMembersResponse
  ): zio.aws.codestar.model.ListTeamMembersResponse.ReadOnly = new Wrapper(impl)
}
