package zio.aws.codestar.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.codestar.model.primitives.{
  UserArn,
  SshPublicKey,
  UserProfileDisplayName,
  CreatedTimestamp,
  Email,
  LastModifiedTimestamp
}
import scala.jdk.CollectionConverters._
final case class DescribeUserProfileResponse(
    userArn: UserArn,
    displayName: Option[UserProfileDisplayName] = None,
    emailAddress: Option[Email] = None,
    sshPublicKey: Option[SshPublicKey] = None,
    createdTimestamp: CreatedTimestamp,
    lastModifiedTimestamp: LastModifiedTimestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestar.model.DescribeUserProfileResponse = {
    import DescribeUserProfileResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestar.model.DescribeUserProfileResponse
      .builder()
      .userArn(UserArn.unwrap(userArn): java.lang.String)
      .optionallyWith(
        displayName.map(value =>
          UserProfileDisplayName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .optionallyWith(
        emailAddress.map(value => Email.unwrap(value): java.lang.String)
      )(_.emailAddress)
      .optionallyWith(
        sshPublicKey.map(value => SshPublicKey.unwrap(value): java.lang.String)
      )(_.sshPublicKey)
      .createdTimestamp(CreatedTimestamp.unwrap(createdTimestamp): Instant)
      .lastModifiedTimestamp(
        LastModifiedTimestamp.unwrap(lastModifiedTimestamp): Instant
      )
      .build()
  }
  def asReadOnly: zio.aws.codestar.model.DescribeUserProfileResponse.ReadOnly =
    zio.aws.codestar.model.DescribeUserProfileResponse.wrap(buildAwsValue())
}
object DescribeUserProfileResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestar.model.DescribeUserProfileResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestar.model.DescribeUserProfileResponse =
      zio.aws.codestar.model.DescribeUserProfileResponse(
        userArn,
        displayName.map(value => value),
        emailAddress.map(value => value),
        sshPublicKey.map(value => value),
        createdTimestamp,
        lastModifiedTimestamp
      )
    def userArn: UserArn
    def displayName: Option[UserProfileDisplayName]
    def emailAddress: Option[Email]
    def sshPublicKey: Option[SshPublicKey]
    def createdTimestamp: CreatedTimestamp
    def lastModifiedTimestamp: LastModifiedTimestamp
    def getUserArn: ZIO[Any, Nothing, UserArn] = ZIO.succeed(userArn)
    def getDisplayName: ZIO[Any, AwsError, UserProfileDisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getEmailAddress: ZIO[Any, AwsError, Email] =
      AwsError.unwrapOptionField("emailAddress", emailAddress)
    def getSshPublicKey: ZIO[Any, AwsError, SshPublicKey] =
      AwsError.unwrapOptionField("sshPublicKey", sshPublicKey)
    def getCreatedTimestamp: ZIO[Any, Nothing, CreatedTimestamp] =
      ZIO.succeed(createdTimestamp)
    def getLastModifiedTimestamp: ZIO[Any, Nothing, LastModifiedTimestamp] =
      ZIO.succeed(lastModifiedTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestar.model.DescribeUserProfileResponse
  ) extends zio.aws.codestar.model.DescribeUserProfileResponse.ReadOnly {
    override val userArn: UserArn =
      zio.aws.codestar.model.primitives.UserArn(impl.userArn())
    override val displayName: Option[UserProfileDisplayName] = scala
      .Option(impl.displayName())
      .map(value =>
        zio.aws.codestar.model.primitives.UserProfileDisplayName(value)
      )
    override val emailAddress: Option[Email] = scala
      .Option(impl.emailAddress())
      .map(value => zio.aws.codestar.model.primitives.Email(value))
    override val sshPublicKey: Option[SshPublicKey] = scala
      .Option(impl.sshPublicKey())
      .map(value => zio.aws.codestar.model.primitives.SshPublicKey(value))
    override val createdTimestamp: CreatedTimestamp =
      zio.aws.codestar.model.primitives
        .CreatedTimestamp(impl.createdTimestamp())
    override val lastModifiedTimestamp: LastModifiedTimestamp =
      zio.aws.codestar.model.primitives
        .LastModifiedTimestamp(impl.lastModifiedTimestamp())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestar.model.DescribeUserProfileResponse
  ): zio.aws.codestar.model.DescribeUserProfileResponse.ReadOnly = new Wrapper(
    impl
  )
}
