package zio.aws.codestar.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codestar.model.primitives.{
  MaxResults,
  PaginationToken,
  ProjectId
}
import scala.jdk.CollectionConverters._
final case class ListResourcesRequest(
    projectId: ProjectId,
    nextToken: Option[PaginationToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestar.model.ListResourcesRequest = {
    import ListResourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestar.model.ListResourcesRequest
      .builder()
      .projectId(ProjectId.unwrap(projectId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.codestar.model.ListResourcesRequest.ReadOnly =
    zio.aws.codestar.model.ListResourcesRequest.wrap(buildAwsValue())
}
object ListResourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestar.model.ListResourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestar.model.ListResourcesRequest =
      zio.aws.codestar.model.ListResourcesRequest(
        projectId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def projectId: ProjectId
    def nextToken: Option[PaginationToken]
    def maxResults: Option[MaxResults]
    def getProjectId: ZIO[Any, Nothing, ProjectId] = ZIO.succeed(projectId)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestar.model.ListResourcesRequest
  ) extends zio.aws.codestar.model.ListResourcesRequest.ReadOnly {
    override val projectId: ProjectId =
      zio.aws.codestar.model.primitives.ProjectId(impl.projectId())
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.codestar.model.primitives.PaginationToken(value))
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.codestar.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestar.model.ListResourcesRequest
  ): zio.aws.codestar.model.ListResourcesRequest.ReadOnly = new Wrapper(impl)
}
