package zio.aws.codestar.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.codestar.model.primitives.{
  UserArn,
  RemoteAccessAllowed,
  ProjectId,
  ClientRequestToken,
  Role
}
import scala.jdk.CollectionConverters._
final case class AssociateTeamMemberRequest(
    projectId: ProjectId,
    clientRequestToken: Option[ClientRequestToken] = None,
    userArn: UserArn,
    projectRole: Role,
    remoteAccessAllowed: Option[RemoteAccessAllowed] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codestar.model.AssociateTeamMemberRequest = {
    import AssociateTeamMemberRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codestar.model.AssociateTeamMemberRequest
      .builder()
      .projectId(ProjectId.unwrap(projectId): java.lang.String)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .userArn(UserArn.unwrap(userArn): java.lang.String)
      .projectRole(Role.unwrap(projectRole): java.lang.String)
      .optionallyWith(
        remoteAccessAllowed.map(value =>
          RemoteAccessAllowed.unwrap(value): java.lang.Boolean
        )
      )(_.remoteAccessAllowed)
      .build()
  }
  def asReadOnly: zio.aws.codestar.model.AssociateTeamMemberRequest.ReadOnly =
    zio.aws.codestar.model.AssociateTeamMemberRequest.wrap(buildAwsValue())
}
object AssociateTeamMemberRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codestar.model.AssociateTeamMemberRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codestar.model.AssociateTeamMemberRequest =
      zio.aws.codestar.model.AssociateTeamMemberRequest(
        projectId,
        clientRequestToken.map(value => value),
        userArn,
        projectRole,
        remoteAccessAllowed.map(value => value)
      )
    def projectId: ProjectId
    def clientRequestToken: Option[ClientRequestToken]
    def userArn: UserArn
    def projectRole: Role
    def remoteAccessAllowed: Option[RemoteAccessAllowed]
    def getProjectId: ZIO[Any, Nothing, ProjectId] = ZIO.succeed(projectId)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getUserArn: ZIO[Any, Nothing, UserArn] = ZIO.succeed(userArn)
    def getProjectRole: ZIO[Any, Nothing, Role] = ZIO.succeed(projectRole)
    def getRemoteAccessAllowed: ZIO[Any, AwsError, RemoteAccessAllowed] =
      AwsError.unwrapOptionField("remoteAccessAllowed", remoteAccessAllowed)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codestar.model.AssociateTeamMemberRequest
  ) extends zio.aws.codestar.model.AssociateTeamMemberRequest.ReadOnly {
    override val projectId: ProjectId =
      zio.aws.codestar.model.primitives.ProjectId(impl.projectId())
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value => zio.aws.codestar.model.primitives.ClientRequestToken(value))
    override val userArn: UserArn =
      zio.aws.codestar.model.primitives.UserArn(impl.userArn())
    override val projectRole: Role =
      zio.aws.codestar.model.primitives.Role(impl.projectRole())
    override val remoteAccessAllowed: Option[RemoteAccessAllowed] = scala
      .Option(impl.remoteAccessAllowed())
      .map(value =>
        zio.aws.codestar.model.primitives.RemoteAccessAllowed(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codestar.model.AssociateTeamMemberRequest
  ): zio.aws.codestar.model.AssociateTeamMemberRequest.ReadOnly = new Wrapper(
    impl
  )
}
