package zio.aws.codepipeline.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.codepipeline.model.primitives.{
  PipelineVersion,
  AWSRegionName,
  RoleArn,
  PipelineName
}
import scala.jdk.CollectionConverters.*
final case class PipelineDeclaration(
    name: PipelineName,
    roleArn: RoleArn,
    artifactStore: Optional[zio.aws.codepipeline.model.ArtifactStore] =
      Optional.Absent,
    artifactStores: Optional[
      Map[AWSRegionName, zio.aws.codepipeline.model.ArtifactStore]
    ] = Optional.Absent,
    stages: Iterable[zio.aws.codepipeline.model.StageDeclaration],
    version: Optional[PipelineVersion] = Optional.Absent,
    pipelineType: Optional[zio.aws.codepipeline.model.PipelineType] =
      Optional.Absent,
    triggers: Optional[
      Iterable[zio.aws.codepipeline.model.PipelineTriggerDeclaration]
    ] = Optional.Absent,
    variables: Optional[
      Iterable[zio.aws.codepipeline.model.PipelineVariableDeclaration]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.PipelineDeclaration = {
    import PipelineDeclaration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.PipelineDeclaration
      .builder()
      .name(PipelineName.unwrap(name): java.lang.String)
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(artifactStore.map(value => value.buildAwsValue()))(
        _.artifactStore
      )
      .optionallyWith(
        artifactStores.map(value =>
          value
            .map({ case (key, value) =>
              (AWSRegionName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.artifactStores)
      .stages(stages.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        version.map(value => PipelineVersion.unwrap(value): Integer)
      )(_.version)
      .optionallyWith(pipelineType.map(value => value.unwrap))(_.pipelineType)
      .optionallyWith(
        triggers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.triggers)
      .optionallyWith(
        variables.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.variables)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.PipelineDeclaration.ReadOnly =
    zio.aws.codepipeline.model.PipelineDeclaration.wrap(buildAwsValue())
}
object PipelineDeclaration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.PipelineDeclaration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.PipelineDeclaration =
      zio.aws.codepipeline.model.PipelineDeclaration(
        name,
        roleArn,
        artifactStore.map(value => value.asEditable),
        artifactStores.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        stages.map { item =>
          item.asEditable
        },
        version.map(value => value),
        pipelineType.map(value => value),
        triggers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        variables.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: PipelineName
    def roleArn: RoleArn
    def artifactStore
        : Optional[zio.aws.codepipeline.model.ArtifactStore.ReadOnly]
    def artifactStores: Optional[
      Map[AWSRegionName, zio.aws.codepipeline.model.ArtifactStore.ReadOnly]
    ]
    def stages: List[zio.aws.codepipeline.model.StageDeclaration.ReadOnly]
    def version: Optional[PipelineVersion]
    def pipelineType: Optional[zio.aws.codepipeline.model.PipelineType]
    def triggers: Optional[
      List[zio.aws.codepipeline.model.PipelineTriggerDeclaration.ReadOnly]
    ]
    def variables: Optional[
      List[zio.aws.codepipeline.model.PipelineVariableDeclaration.ReadOnly]
    ]
    def getName: ZIO[Any, Nothing, PipelineName] = ZIO.succeed(name)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getArtifactStore: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.ArtifactStore.ReadOnly
    ] = AwsError.unwrapOptionField("artifactStore", artifactStore)
    def getArtifactStores: ZIO[Any, AwsError, Map[
      AWSRegionName,
      zio.aws.codepipeline.model.ArtifactStore.ReadOnly
    ]] = AwsError.unwrapOptionField("artifactStores", artifactStores)
    def getStages: ZIO[Any, Nothing, List[
      zio.aws.codepipeline.model.StageDeclaration.ReadOnly
    ]] = ZIO.succeed(stages)
    def getVersion: ZIO[Any, AwsError, PipelineVersion] =
      AwsError.unwrapOptionField("version", version)
    def getPipelineType
        : ZIO[Any, AwsError, zio.aws.codepipeline.model.PipelineType] =
      AwsError.unwrapOptionField("pipelineType", pipelineType)
    def getTriggers: ZIO[Any, AwsError, List[
      zio.aws.codepipeline.model.PipelineTriggerDeclaration.ReadOnly
    ]] = AwsError.unwrapOptionField("triggers", triggers)
    def getVariables: ZIO[Any, AwsError, List[
      zio.aws.codepipeline.model.PipelineVariableDeclaration.ReadOnly
    ]] = AwsError.unwrapOptionField("variables", variables)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.PipelineDeclaration
  ) extends zio.aws.codepipeline.model.PipelineDeclaration.ReadOnly {
    override val name: PipelineName =
      zio.aws.codepipeline.model.primitives.PipelineName(impl.name())
    override val roleArn: RoleArn =
      zio.aws.codepipeline.model.primitives.RoleArn(impl.roleArn())
    override val artifactStore
        : Optional[zio.aws.codepipeline.model.ArtifactStore.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.artifactStore())
        .map(value => zio.aws.codepipeline.model.ArtifactStore.wrap(value))
    override val artifactStores: Optional[
      Map[AWSRegionName, zio.aws.codepipeline.model.ArtifactStore.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.artifactStores())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.codepipeline.model.primitives.AWSRegionName(
              key
            ) -> zio.aws.codepipeline.model.ArtifactStore.wrap(value)
          })
          .toMap
      )
    override val stages
        : List[zio.aws.codepipeline.model.StageDeclaration.ReadOnly] = impl
      .stages()
      .asScala
      .map { item =>
        zio.aws.codepipeline.model.StageDeclaration.wrap(item)
      }
      .toList
    override val version: Optional[PipelineVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value =>
        zio.aws.codepipeline.model.primitives.PipelineVersion(value)
      )
    override val pipelineType
        : Optional[zio.aws.codepipeline.model.PipelineType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipelineType())
        .map(value => zio.aws.codepipeline.model.PipelineType.wrap(value))
    override val triggers: Optional[
      List[zio.aws.codepipeline.model.PipelineTriggerDeclaration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.triggers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codepipeline.model.PipelineTriggerDeclaration.wrap(item)
        }.toList
      )
    override val variables: Optional[
      List[zio.aws.codepipeline.model.PipelineVariableDeclaration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.variables())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.codepipeline.model.PipelineVariableDeclaration.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.PipelineDeclaration
  ): zio.aws.codepipeline.model.PipelineDeclaration.ReadOnly = new Wrapper(impl)
}
