package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{Nonce, ThirdPartyJobId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ThirdPartyJobDetails(
    id: Optional[ThirdPartyJobId] = Optional.Absent,
    data: Optional[zio.aws.codepipeline.model.ThirdPartyJobData] =
      Optional.Absent,
    nonce: Optional[Nonce] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ThirdPartyJobDetails = {
    import ThirdPartyJobDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ThirdPartyJobDetails
      .builder()
      .optionallyWith(
        id.map(value => ThirdPartyJobId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(data.map(value => value.buildAwsValue()))(_.data)
      .optionallyWith(
        nonce.map(value => Nonce.unwrap(value): java.lang.String)
      )(_.nonce)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.ThirdPartyJobDetails.ReadOnly =
    zio.aws.codepipeline.model.ThirdPartyJobDetails.wrap(buildAwsValue())
}
object ThirdPartyJobDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ThirdPartyJobDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ThirdPartyJobDetails =
      zio.aws.codepipeline.model.ThirdPartyJobDetails(
        id.map(value => value),
        data.map(value => value.asEditable),
        nonce.map(value => value)
      )
    def id: Optional[ThirdPartyJobId]
    def data: Optional[zio.aws.codepipeline.model.ThirdPartyJobData.ReadOnly]
    def nonce: Optional[Nonce]
    def getId: ZIO[Any, AwsError, ThirdPartyJobId] =
      AwsError.unwrapOptionField("id", id)
    def getData: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.ThirdPartyJobData.ReadOnly
    ] = AwsError.unwrapOptionField("data", data)
    def getNonce: ZIO[Any, AwsError, Nonce] =
      AwsError.unwrapOptionField("nonce", nonce)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ThirdPartyJobDetails
  ) extends zio.aws.codepipeline.model.ThirdPartyJobDetails.ReadOnly {
    override val id: Optional[ThirdPartyJobId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value =>
        zio.aws.codepipeline.model.primitives.ThirdPartyJobId(value)
      )
    override val data
        : Optional[zio.aws.codepipeline.model.ThirdPartyJobData.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.data())
        .map(value => zio.aws.codepipeline.model.ThirdPartyJobData.wrap(value))
    override val nonce: Optional[Nonce] = zio.aws.core.internal
      .optionalFromNullable(impl.nonce())
      .map(value => zio.aws.codepipeline.model.primitives.Nonce(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ThirdPartyJobDetails
  ): zio.aws.codepipeline.model.ThirdPartyJobDetails.ReadOnly = new Wrapper(
    impl
  )
}
