package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.ContinuationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ThirdPartyJobData(
    actionTypeId: Optional[zio.aws.codepipeline.model.ActionTypeId] =
      Optional.Absent,
    actionConfiguration: Optional[
      zio.aws.codepipeline.model.ActionConfiguration
    ] = Optional.Absent,
    pipelineContext: Optional[zio.aws.codepipeline.model.PipelineContext] =
      Optional.Absent,
    inputArtifacts: Optional[Iterable[zio.aws.codepipeline.model.Artifact]] =
      Optional.Absent,
    outputArtifacts: Optional[Iterable[zio.aws.codepipeline.model.Artifact]] =
      Optional.Absent,
    artifactCredentials: Optional[
      zio.aws.codepipeline.model.AWSSessionCredentials
    ] = Optional.Absent,
    continuationToken: Optional[ContinuationToken] = Optional.Absent,
    encryptionKey: Optional[zio.aws.codepipeline.model.EncryptionKey] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ThirdPartyJobData = {
    import ThirdPartyJobData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ThirdPartyJobData
      .builder()
      .optionallyWith(actionTypeId.map(value => value.buildAwsValue()))(
        _.actionTypeId
      )
      .optionallyWith(actionConfiguration.map(value => value.buildAwsValue()))(
        _.actionConfiguration
      )
      .optionallyWith(pipelineContext.map(value => value.buildAwsValue()))(
        _.pipelineContext
      )
      .optionallyWith(
        inputArtifacts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inputArtifacts)
      .optionallyWith(
        outputArtifacts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.outputArtifacts)
      .optionallyWith(artifactCredentials.map(value => value.buildAwsValue()))(
        _.artifactCredentials
      )
      .optionallyWith(
        continuationToken.map(value =>
          ContinuationToken.unwrap(value): java.lang.String
        )
      )(_.continuationToken)
      .optionallyWith(encryptionKey.map(value => value.buildAwsValue()))(
        _.encryptionKey
      )
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.ThirdPartyJobData.ReadOnly =
    zio.aws.codepipeline.model.ThirdPartyJobData.wrap(buildAwsValue())
}
object ThirdPartyJobData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ThirdPartyJobData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ThirdPartyJobData =
      zio.aws.codepipeline.model.ThirdPartyJobData(
        actionTypeId.map(value => value.asEditable),
        actionConfiguration.map(value => value.asEditable),
        pipelineContext.map(value => value.asEditable),
        inputArtifacts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        outputArtifacts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        artifactCredentials.map(value => value.asEditable),
        continuationToken.map(value => value),
        encryptionKey.map(value => value.asEditable)
      )
    def actionTypeId: Optional[zio.aws.codepipeline.model.ActionTypeId.ReadOnly]
    def actionConfiguration
        : Optional[zio.aws.codepipeline.model.ActionConfiguration.ReadOnly]
    def pipelineContext
        : Optional[zio.aws.codepipeline.model.PipelineContext.ReadOnly]
    def inputArtifacts
        : Optional[List[zio.aws.codepipeline.model.Artifact.ReadOnly]]
    def outputArtifacts
        : Optional[List[zio.aws.codepipeline.model.Artifact.ReadOnly]]
    def artifactCredentials
        : Optional[zio.aws.codepipeline.model.AWSSessionCredentials.ReadOnly]
    def continuationToken: Optional[ContinuationToken]
    def encryptionKey
        : Optional[zio.aws.codepipeline.model.EncryptionKey.ReadOnly]
    def getActionTypeId
        : ZIO[Any, AwsError, zio.aws.codepipeline.model.ActionTypeId.ReadOnly] =
      AwsError.unwrapOptionField("actionTypeId", actionTypeId)
    def getActionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.ActionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("actionConfiguration", actionConfiguration)
    def getPipelineContext: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.PipelineContext.ReadOnly
    ] = AwsError.unwrapOptionField("pipelineContext", pipelineContext)
    def getInputArtifacts: ZIO[Any, AwsError, List[
      zio.aws.codepipeline.model.Artifact.ReadOnly
    ]] = AwsError.unwrapOptionField("inputArtifacts", inputArtifacts)
    def getOutputArtifacts: ZIO[Any, AwsError, List[
      zio.aws.codepipeline.model.Artifact.ReadOnly
    ]] = AwsError.unwrapOptionField("outputArtifacts", outputArtifacts)
    def getArtifactCredentials: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.AWSSessionCredentials.ReadOnly
    ] = AwsError.unwrapOptionField("artifactCredentials", artifactCredentials)
    def getContinuationToken: ZIO[Any, AwsError, ContinuationToken] =
      AwsError.unwrapOptionField("continuationToken", continuationToken)
    def getEncryptionKey: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.EncryptionKey.ReadOnly
    ] = AwsError.unwrapOptionField("encryptionKey", encryptionKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ThirdPartyJobData
  ) extends zio.aws.codepipeline.model.ThirdPartyJobData.ReadOnly {
    override val actionTypeId
        : Optional[zio.aws.codepipeline.model.ActionTypeId.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actionTypeId())
        .map(value => zio.aws.codepipeline.model.ActionTypeId.wrap(value))
    override val actionConfiguration
        : Optional[zio.aws.codepipeline.model.ActionConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actionConfiguration())
        .map(value =>
          zio.aws.codepipeline.model.ActionConfiguration.wrap(value)
        )
    override val pipelineContext
        : Optional[zio.aws.codepipeline.model.PipelineContext.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipelineContext())
        .map(value => zio.aws.codepipeline.model.PipelineContext.wrap(value))
    override val inputArtifacts
        : Optional[List[zio.aws.codepipeline.model.Artifact.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inputArtifacts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codepipeline.model.Artifact.wrap(item)
          }.toList
        )
    override val outputArtifacts
        : Optional[List[zio.aws.codepipeline.model.Artifact.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputArtifacts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codepipeline.model.Artifact.wrap(item)
          }.toList
        )
    override val artifactCredentials
        : Optional[zio.aws.codepipeline.model.AWSSessionCredentials.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.artifactCredentials())
        .map(value =>
          zio.aws.codepipeline.model.AWSSessionCredentials.wrap(value)
        )
    override val continuationToken: Optional[ContinuationToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.continuationToken())
        .map(value =>
          zio.aws.codepipeline.model.primitives.ContinuationToken(value)
        )
    override val encryptionKey
        : Optional[zio.aws.codepipeline.model.EncryptionKey.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionKey())
        .map(value => zio.aws.codepipeline.model.EncryptionKey.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ThirdPartyJobData
  ): zio.aws.codepipeline.model.ThirdPartyJobData.ReadOnly = new Wrapper(impl)
}
