package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.AllowedAccount
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ActionTypePermissions(
    allowedAccounts: Iterable[AllowedAccount]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ActionTypePermissions = {
    import ActionTypePermissions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ActionTypePermissions
      .builder()
      .allowedAccounts(allowedAccounts.map { item =>
        AllowedAccount.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.ActionTypePermissions.ReadOnly =
    zio.aws.codepipeline.model.ActionTypePermissions.wrap(buildAwsValue())
}
object ActionTypePermissions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ActionTypePermissions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ActionTypePermissions =
      zio.aws.codepipeline.model.ActionTypePermissions(allowedAccounts)
    def allowedAccounts: List[AllowedAccount]
    def getAllowedAccounts: ZIO[Any, Nothing, List[AllowedAccount]] =
      ZIO.succeed(allowedAccounts)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ActionTypePermissions
  ) extends zio.aws.codepipeline.model.ActionTypePermissions.ReadOnly {
    override val allowedAccounts: List[AllowedAccount] = impl
      .allowedAccounts()
      .asScala
      .map { item =>
        zio.aws.codepipeline.model.primitives.AllowedAccount(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ActionTypePermissions
  ): zio.aws.codepipeline.model.ActionTypePermissions.ReadOnly = new Wrapper(
    impl
  )
}
