package zio.aws.codepipeline.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.codepipeline.model.primitives.MaxBatchSize
import scala.jdk.CollectionConverters.*
final case class PollForThirdPartyJobsRequest(
    actionTypeId: zio.aws.codepipeline.model.ActionTypeId,
    maxBatchSize: Optional[MaxBatchSize] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.PollForThirdPartyJobsRequest = {
    import PollForThirdPartyJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.PollForThirdPartyJobsRequest
      .builder()
      .actionTypeId(actionTypeId.buildAwsValue())
      .optionallyWith(
        maxBatchSize.map(value => MaxBatchSize.unwrap(value): Integer)
      )(_.maxBatchSize)
      .build()
  }
  def asReadOnly
      : zio.aws.codepipeline.model.PollForThirdPartyJobsRequest.ReadOnly =
    zio.aws.codepipeline.model.PollForThirdPartyJobsRequest
      .wrap(buildAwsValue())
}
object PollForThirdPartyJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.PollForThirdPartyJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.PollForThirdPartyJobsRequest =
      zio.aws.codepipeline.model.PollForThirdPartyJobsRequest(
        actionTypeId.asEditable,
        maxBatchSize.map(value => value)
      )
    def actionTypeId: zio.aws.codepipeline.model.ActionTypeId.ReadOnly
    def maxBatchSize: Optional[MaxBatchSize]
    def getActionTypeId
        : ZIO[Any, Nothing, zio.aws.codepipeline.model.ActionTypeId.ReadOnly] =
      ZIO.succeed(actionTypeId)
    def getMaxBatchSize: ZIO[Any, AwsError, MaxBatchSize] =
      AwsError.unwrapOptionField("maxBatchSize", maxBatchSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.PollForThirdPartyJobsRequest
  ) extends zio.aws.codepipeline.model.PollForThirdPartyJobsRequest.ReadOnly {
    override val actionTypeId
        : zio.aws.codepipeline.model.ActionTypeId.ReadOnly =
      zio.aws.codepipeline.model.ActionTypeId.wrap(impl.actionTypeId())
    override val maxBatchSize: Optional[MaxBatchSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maxBatchSize())
      .map(value => zio.aws.codepipeline.model.primitives.MaxBatchSize(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.PollForThirdPartyJobsRequest
  ): zio.aws.codepipeline.model.PollForThirdPartyJobsRequest.ReadOnly =
    new Wrapper(impl)
}
