package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.StageName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class StageState(
    stageName: Optional[StageName] = Optional.Absent,
    inboundExecution: Optional[zio.aws.codepipeline.model.StageExecution] =
      Optional.Absent,
    inboundTransitionState: Optional[
      zio.aws.codepipeline.model.TransitionState
    ] = Optional.Absent,
    actionStates: Optional[Iterable[zio.aws.codepipeline.model.ActionState]] =
      Optional.Absent,
    latestExecution: Optional[zio.aws.codepipeline.model.StageExecution] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.StageState = {
    import StageState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.StageState
      .builder()
      .optionallyWith(
        stageName.map(value => StageName.unwrap(value): java.lang.String)
      )(_.stageName)
      .optionallyWith(inboundExecution.map(value => value.buildAwsValue()))(
        _.inboundExecution
      )
      .optionallyWith(
        inboundTransitionState.map(value => value.buildAwsValue())
      )(_.inboundTransitionState)
      .optionallyWith(
        actionStates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.actionStates)
      .optionallyWith(latestExecution.map(value => value.buildAwsValue()))(
        _.latestExecution
      )
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.StageState.ReadOnly =
    zio.aws.codepipeline.model.StageState.wrap(buildAwsValue())
}
object StageState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.StageState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.StageState =
      zio.aws.codepipeline.model.StageState(
        stageName.map(value => value),
        inboundExecution.map(value => value.asEditable),
        inboundTransitionState.map(value => value.asEditable),
        actionStates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        latestExecution.map(value => value.asEditable)
      )
    def stageName: Optional[StageName]
    def inboundExecution
        : Optional[zio.aws.codepipeline.model.StageExecution.ReadOnly]
    def inboundTransitionState
        : Optional[zio.aws.codepipeline.model.TransitionState.ReadOnly]
    def actionStates
        : Optional[List[zio.aws.codepipeline.model.ActionState.ReadOnly]]
    def latestExecution
        : Optional[zio.aws.codepipeline.model.StageExecution.ReadOnly]
    def getStageName: ZIO[Any, AwsError, StageName] =
      AwsError.unwrapOptionField("stageName", stageName)
    def getInboundExecution: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.StageExecution.ReadOnly
    ] = AwsError.unwrapOptionField("inboundExecution", inboundExecution)
    def getInboundTransitionState: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.TransitionState.ReadOnly
    ] = AwsError.unwrapOptionField(
      "inboundTransitionState",
      inboundTransitionState
    )
    def getActionStates: ZIO[Any, AwsError, List[
      zio.aws.codepipeline.model.ActionState.ReadOnly
    ]] = AwsError.unwrapOptionField("actionStates", actionStates)
    def getLatestExecution: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.StageExecution.ReadOnly
    ] = AwsError.unwrapOptionField("latestExecution", latestExecution)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.StageState
  ) extends zio.aws.codepipeline.model.StageState.ReadOnly {
    override val stageName: Optional[StageName] = zio.aws.core.internal
      .optionalFromNullable(impl.stageName())
      .map(value => zio.aws.codepipeline.model.primitives.StageName(value))
    override val inboundExecution
        : Optional[zio.aws.codepipeline.model.StageExecution.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inboundExecution())
        .map(value => zio.aws.codepipeline.model.StageExecution.wrap(value))
    override val inboundTransitionState
        : Optional[zio.aws.codepipeline.model.TransitionState.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inboundTransitionState())
        .map(value => zio.aws.codepipeline.model.TransitionState.wrap(value))
    override val actionStates
        : Optional[List[zio.aws.codepipeline.model.ActionState.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actionStates())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codepipeline.model.ActionState.wrap(item)
          }.toList
        )
    override val latestExecution
        : Optional[zio.aws.codepipeline.model.StageExecution.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestExecution())
        .map(value => zio.aws.codepipeline.model.StageExecution.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.StageState
  ): zio.aws.codepipeline.model.StageState.ReadOnly = new Wrapper(impl)
}
