package zio.aws.codepipeline.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.codepipeline.model.primitives.{
  PipelineExecutionStatusSummary,
  PipelineExecutionId,
  PipelineVersion,
  PipelineName
}
import scala.jdk.CollectionConverters.*
final case class PipelineExecution(
    pipelineName: Optional[PipelineName] = Optional.Absent,
    pipelineVersion: Optional[PipelineVersion] = Optional.Absent,
    pipelineExecutionId: Optional[PipelineExecutionId] = Optional.Absent,
    status: Optional[zio.aws.codepipeline.model.PipelineExecutionStatus] =
      Optional.Absent,
    statusSummary: Optional[PipelineExecutionStatusSummary] = Optional.Absent,
    artifactRevisions: Optional[
      Iterable[zio.aws.codepipeline.model.ArtifactRevision]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.PipelineExecution = {
    import PipelineExecution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.PipelineExecution
      .builder()
      .optionallyWith(
        pipelineName.map(value => PipelineName.unwrap(value): java.lang.String)
      )(_.pipelineName)
      .optionallyWith(
        pipelineVersion.map(value => PipelineVersion.unwrap(value): Integer)
      )(_.pipelineVersion)
      .optionallyWith(
        pipelineExecutionId.map(value =>
          PipelineExecutionId.unwrap(value): java.lang.String
        )
      )(_.pipelineExecutionId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusSummary.map(value =>
          PipelineExecutionStatusSummary.unwrap(value): java.lang.String
        )
      )(_.statusSummary)
      .optionallyWith(
        artifactRevisions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.artifactRevisions)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.PipelineExecution.ReadOnly =
    zio.aws.codepipeline.model.PipelineExecution.wrap(buildAwsValue())
}
object PipelineExecution {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.PipelineExecution
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.PipelineExecution =
      zio.aws.codepipeline.model.PipelineExecution(
        pipelineName.map(value => value),
        pipelineVersion.map(value => value),
        pipelineExecutionId.map(value => value),
        status.map(value => value),
        statusSummary.map(value => value),
        artifactRevisions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def pipelineName: Optional[PipelineName]
    def pipelineVersion: Optional[PipelineVersion]
    def pipelineExecutionId: Optional[PipelineExecutionId]
    def status: Optional[zio.aws.codepipeline.model.PipelineExecutionStatus]
    def statusSummary: Optional[PipelineExecutionStatusSummary]
    def artifactRevisions
        : Optional[List[zio.aws.codepipeline.model.ArtifactRevision.ReadOnly]]
    def getPipelineName: ZIO[Any, AwsError, PipelineName] =
      AwsError.unwrapOptionField("pipelineName", pipelineName)
    def getPipelineVersion: ZIO[Any, AwsError, PipelineVersion] =
      AwsError.unwrapOptionField("pipelineVersion", pipelineVersion)
    def getPipelineExecutionId: ZIO[Any, AwsError, PipelineExecutionId] =
      AwsError.unwrapOptionField("pipelineExecutionId", pipelineExecutionId)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.PipelineExecutionStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getStatusSummary: ZIO[Any, AwsError, PipelineExecutionStatusSummary] =
      AwsError.unwrapOptionField("statusSummary", statusSummary)
    def getArtifactRevisions: ZIO[Any, AwsError, List[
      zio.aws.codepipeline.model.ArtifactRevision.ReadOnly
    ]] = AwsError.unwrapOptionField("artifactRevisions", artifactRevisions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.PipelineExecution
  ) extends zio.aws.codepipeline.model.PipelineExecution.ReadOnly {
    override val pipelineName: Optional[PipelineName] = zio.aws.core.internal
      .optionalFromNullable(impl.pipelineName())
      .map(value => zio.aws.codepipeline.model.primitives.PipelineName(value))
    override val pipelineVersion: Optional[PipelineVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipelineVersion())
        .map(value =>
          zio.aws.codepipeline.model.primitives.PipelineVersion(value)
        )
    override val pipelineExecutionId: Optional[PipelineExecutionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipelineExecutionId())
        .map(value =>
          zio.aws.codepipeline.model.primitives.PipelineExecutionId(value)
        )
    override val status
        : Optional[zio.aws.codepipeline.model.PipelineExecutionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.codepipeline.model.PipelineExecutionStatus.wrap(value)
        )
    override val statusSummary: Optional[PipelineExecutionStatusSummary] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusSummary())
        .map(value =>
          zio.aws.codepipeline.model.primitives
            .PipelineExecutionStatusSummary(value)
        )
    override val artifactRevisions
        : Optional[List[zio.aws.codepipeline.model.ArtifactRevision.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.artifactRevisions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.codepipeline.model.ArtifactRevision.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.PipelineExecution
  ): zio.aws.codepipeline.model.PipelineExecution.ReadOnly = new Wrapper(impl)
}
