package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{
  ContinuationToken,
  ClientToken,
  ThirdPartyJobId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PutThirdPartyJobSuccessResultRequest(
    jobId: ThirdPartyJobId,
    clientToken: ClientToken,
    currentRevision: Optional[zio.aws.codepipeline.model.CurrentRevision] =
      Optional.Absent,
    continuationToken: Optional[ContinuationToken] = Optional.Absent,
    executionDetails: Optional[zio.aws.codepipeline.model.ExecutionDetails] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.PutThirdPartyJobSuccessResultRequest = {
    import PutThirdPartyJobSuccessResultRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.PutThirdPartyJobSuccessResultRequest
      .builder()
      .jobId(ThirdPartyJobId.unwrap(jobId): java.lang.String)
      .clientToken(ClientToken.unwrap(clientToken): java.lang.String)
      .optionallyWith(currentRevision.map(value => value.buildAwsValue()))(
        _.currentRevision
      )
      .optionallyWith(
        continuationToken.map(value =>
          ContinuationToken.unwrap(value): java.lang.String
        )
      )(_.continuationToken)
      .optionallyWith(executionDetails.map(value => value.buildAwsValue()))(
        _.executionDetails
      )
      .build()
  }
  def asReadOnly
      : zio.aws.codepipeline.model.PutThirdPartyJobSuccessResultRequest.ReadOnly =
    zio.aws.codepipeline.model.PutThirdPartyJobSuccessResultRequest
      .wrap(buildAwsValue())
}
object PutThirdPartyJobSuccessResultRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.PutThirdPartyJobSuccessResultRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.codepipeline.model.PutThirdPartyJobSuccessResultRequest =
      zio.aws.codepipeline.model.PutThirdPartyJobSuccessResultRequest(
        jobId,
        clientToken,
        currentRevision.map(value => value.asEditable),
        continuationToken.map(value => value),
        executionDetails.map(value => value.asEditable)
      )
    def jobId: ThirdPartyJobId
    def clientToken: ClientToken
    def currentRevision
        : Optional[zio.aws.codepipeline.model.CurrentRevision.ReadOnly]
    def continuationToken: Optional[ContinuationToken]
    def executionDetails
        : Optional[zio.aws.codepipeline.model.ExecutionDetails.ReadOnly]
    def getJobId: ZIO[Any, Nothing, ThirdPartyJobId] = ZIO.succeed(jobId)
    def getClientToken: ZIO[Any, Nothing, ClientToken] =
      ZIO.succeed(clientToken)
    def getCurrentRevision: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.CurrentRevision.ReadOnly
    ] = AwsError.unwrapOptionField("currentRevision", currentRevision)
    def getContinuationToken: ZIO[Any, AwsError, ContinuationToken] =
      AwsError.unwrapOptionField("continuationToken", continuationToken)
    def getExecutionDetails: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.ExecutionDetails.ReadOnly
    ] = AwsError.unwrapOptionField("executionDetails", executionDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.PutThirdPartyJobSuccessResultRequest
  ) extends zio.aws.codepipeline.model.PutThirdPartyJobSuccessResultRequest.ReadOnly {
    override val jobId: ThirdPartyJobId =
      zio.aws.codepipeline.model.primitives.ThirdPartyJobId(impl.jobId())
    override val clientToken: ClientToken =
      zio.aws.codepipeline.model.primitives.ClientToken(impl.clientToken())
    override val currentRevision
        : Optional[zio.aws.codepipeline.model.CurrentRevision.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentRevision())
        .map(value => zio.aws.codepipeline.model.CurrentRevision.wrap(value))
    override val continuationToken: Optional[ContinuationToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.continuationToken())
        .map(value =>
          zio.aws.codepipeline.model.primitives.ContinuationToken(value)
        )
    override val executionDetails
        : Optional[zio.aws.codepipeline.model.ExecutionDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionDetails())
        .map(value => zio.aws.codepipeline.model.ExecutionDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.PutThirdPartyJobSuccessResultRequest
  ): zio.aws.codepipeline.model.PutThirdPartyJobSuccessResultRequest.ReadOnly =
    new Wrapper(impl)
}
