package zio.aws.codepipeline.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.codepipeline.model.primitives.{
  RevisionSummary,
  RevisionChangeIdentifier,
  Url,
  Timestamp,
  Revision,
  ArtifactName
}
import scala.jdk.CollectionConverters.*
final case class ArtifactRevision(
    name: Optional[ArtifactName] = Optional.Absent,
    revisionId: Optional[Revision] = Optional.Absent,
    revisionChangeIdentifier: Optional[RevisionChangeIdentifier] =
      Optional.Absent,
    revisionSummary: Optional[RevisionSummary] = Optional.Absent,
    created: Optional[Timestamp] = Optional.Absent,
    revisionUrl: Optional[Url] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ArtifactRevision = {
    import ArtifactRevision.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ArtifactRevision
      .builder()
      .optionallyWith(
        name.map(value => ArtifactName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        revisionId.map(value => Revision.unwrap(value): java.lang.String)
      )(_.revisionId)
      .optionallyWith(
        revisionChangeIdentifier.map(value =>
          RevisionChangeIdentifier.unwrap(value): java.lang.String
        )
      )(_.revisionChangeIdentifier)
      .optionallyWith(
        revisionSummary.map(value =>
          RevisionSummary.unwrap(value): java.lang.String
        )
      )(_.revisionSummary)
      .optionallyWith(created.map(value => Timestamp.unwrap(value): Instant))(
        _.created
      )
      .optionallyWith(
        revisionUrl.map(value => Url.unwrap(value): java.lang.String)
      )(_.revisionUrl)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.ArtifactRevision.ReadOnly =
    zio.aws.codepipeline.model.ArtifactRevision.wrap(buildAwsValue())
}
object ArtifactRevision {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ArtifactRevision
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ArtifactRevision =
      zio.aws.codepipeline.model.ArtifactRevision(
        name.map(value => value),
        revisionId.map(value => value),
        revisionChangeIdentifier.map(value => value),
        revisionSummary.map(value => value),
        created.map(value => value),
        revisionUrl.map(value => value)
      )
    def name: Optional[ArtifactName]
    def revisionId: Optional[Revision]
    def revisionChangeIdentifier: Optional[RevisionChangeIdentifier]
    def revisionSummary: Optional[RevisionSummary]
    def created: Optional[Timestamp]
    def revisionUrl: Optional[Url]
    def getName: ZIO[Any, AwsError, ArtifactName] =
      AwsError.unwrapOptionField("name", name)
    def getRevisionId: ZIO[Any, AwsError, Revision] =
      AwsError.unwrapOptionField("revisionId", revisionId)
    def getRevisionChangeIdentifier
        : ZIO[Any, AwsError, RevisionChangeIdentifier] = AwsError
      .unwrapOptionField("revisionChangeIdentifier", revisionChangeIdentifier)
    def getRevisionSummary: ZIO[Any, AwsError, RevisionSummary] =
      AwsError.unwrapOptionField("revisionSummary", revisionSummary)
    def getCreated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("created", created)
    def getRevisionUrl: ZIO[Any, AwsError, Url] =
      AwsError.unwrapOptionField("revisionUrl", revisionUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ArtifactRevision
  ) extends zio.aws.codepipeline.model.ArtifactRevision.ReadOnly {
    override val name: Optional[ArtifactName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.codepipeline.model.primitives.ArtifactName(value))
    override val revisionId: Optional[Revision] = zio.aws.core.internal
      .optionalFromNullable(impl.revisionId())
      .map(value => zio.aws.codepipeline.model.primitives.Revision(value))
    override val revisionChangeIdentifier: Optional[RevisionChangeIdentifier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.revisionChangeIdentifier())
        .map(value =>
          zio.aws.codepipeline.model.primitives.RevisionChangeIdentifier(value)
        )
    override val revisionSummary: Optional[RevisionSummary] =
      zio.aws.core.internal
        .optionalFromNullable(impl.revisionSummary())
        .map(value =>
          zio.aws.codepipeline.model.primitives.RevisionSummary(value)
        )
    override val created: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.created())
      .map(value => zio.aws.codepipeline.model.primitives.Timestamp(value))
    override val revisionUrl: Optional[Url] = zio.aws.core.internal
      .optionalFromNullable(impl.revisionUrl())
      .map(value => zio.aws.codepipeline.model.primitives.Url(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ArtifactRevision
  ): zio.aws.codepipeline.model.ArtifactRevision.ReadOnly = new Wrapper(impl)
}
