package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.ArtifactName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class OutputArtifact(name: ArtifactName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.OutputArtifact = {
    import OutputArtifact.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.OutputArtifact
      .builder()
      .name(ArtifactName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.OutputArtifact.ReadOnly =
    zio.aws.codepipeline.model.OutputArtifact.wrap(buildAwsValue())
}
object OutputArtifact {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.OutputArtifact
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.OutputArtifact =
      zio.aws.codepipeline.model.OutputArtifact(name)
    def name: ArtifactName
    def getName: ZIO[Any, Nothing, ArtifactName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.OutputArtifact
  ) extends zio.aws.codepipeline.model.OutputArtifact.ReadOnly {
    override val name: ArtifactName =
      zio.aws.codepipeline.model.primitives.ArtifactName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.OutputArtifact
  ): zio.aws.codepipeline.model.OutputArtifact.ReadOnly = new Wrapper(impl)
}
