package zio.aws.codepipeline.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.codepipeline.model.primitives.{
  PipelineVersion,
  AWSRegionName,
  RoleArn,
  PipelineName
}
import scala.jdk.CollectionConverters.*
final case class PipelineDeclaration(
    name: PipelineName,
    roleArn: RoleArn,
    artifactStore: Optional[zio.aws.codepipeline.model.ArtifactStore] =
      Optional.Absent,
    artifactStores: Optional[
      Map[AWSRegionName, zio.aws.codepipeline.model.ArtifactStore]
    ] = Optional.Absent,
    stages: Iterable[zio.aws.codepipeline.model.StageDeclaration],
    version: Optional[PipelineVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.PipelineDeclaration = {
    import PipelineDeclaration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.PipelineDeclaration
      .builder()
      .name(PipelineName.unwrap(name): java.lang.String)
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(artifactStore.map(value => value.buildAwsValue()))(
        _.artifactStore
      )
      .optionallyWith(
        artifactStores.map(value =>
          value
            .map({ case (key, value) =>
              (AWSRegionName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.artifactStores)
      .stages(stages.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        version.map(value => PipelineVersion.unwrap(value): Integer)
      )(_.version)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.PipelineDeclaration.ReadOnly =
    zio.aws.codepipeline.model.PipelineDeclaration.wrap(buildAwsValue())
}
object PipelineDeclaration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.PipelineDeclaration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.PipelineDeclaration =
      zio.aws.codepipeline.model.PipelineDeclaration(
        name,
        roleArn,
        artifactStore.map(value => value.asEditable),
        artifactStores.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        stages.map { item =>
          item.asEditable
        },
        version.map(value => value)
      )
    def name: PipelineName
    def roleArn: RoleArn
    def artifactStore
        : Optional[zio.aws.codepipeline.model.ArtifactStore.ReadOnly]
    def artifactStores: Optional[
      Map[AWSRegionName, zio.aws.codepipeline.model.ArtifactStore.ReadOnly]
    ]
    def stages: List[zio.aws.codepipeline.model.StageDeclaration.ReadOnly]
    def version: Optional[PipelineVersion]
    def getName: ZIO[Any, Nothing, PipelineName] = ZIO.succeed(name)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getArtifactStore: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.ArtifactStore.ReadOnly
    ] = AwsError.unwrapOptionField("artifactStore", artifactStore)
    def getArtifactStores: ZIO[Any, AwsError, Map[
      AWSRegionName,
      zio.aws.codepipeline.model.ArtifactStore.ReadOnly
    ]] = AwsError.unwrapOptionField("artifactStores", artifactStores)
    def getStages: ZIO[Any, Nothing, List[
      zio.aws.codepipeline.model.StageDeclaration.ReadOnly
    ]] = ZIO.succeed(stages)
    def getVersion: ZIO[Any, AwsError, PipelineVersion] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.PipelineDeclaration
  ) extends zio.aws.codepipeline.model.PipelineDeclaration.ReadOnly {
    override val name: PipelineName =
      zio.aws.codepipeline.model.primitives.PipelineName(impl.name())
    override val roleArn: RoleArn =
      zio.aws.codepipeline.model.primitives.RoleArn(impl.roleArn())
    override val artifactStore
        : Optional[zio.aws.codepipeline.model.ArtifactStore.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.artifactStore())
        .map(value => zio.aws.codepipeline.model.ArtifactStore.wrap(value))
    override val artifactStores: Optional[
      Map[AWSRegionName, zio.aws.codepipeline.model.ArtifactStore.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.artifactStores())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.codepipeline.model.primitives.AWSRegionName(
              key
            ) -> zio.aws.codepipeline.model.ArtifactStore.wrap(value)
          })
          .toMap
      )
    override val stages
        : List[zio.aws.codepipeline.model.StageDeclaration.ReadOnly] = impl
      .stages()
      .asScala
      .map { item =>
        zio.aws.codepipeline.model.StageDeclaration.wrap(item)
      }
      .toList
    override val version: Optional[PipelineVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value =>
        zio.aws.codepipeline.model.primitives.PipelineVersion(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.PipelineDeclaration
  ): zio.aws.codepipeline.model.PipelineDeclaration.ReadOnly = new Wrapper(impl)
}
