package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{
  Url,
  RevisionSummary,
  Revision,
  ActionName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SourceRevision(
    actionName: ActionName,
    revisionId: Optional[Revision] = Optional.Absent,
    revisionSummary: Optional[RevisionSummary] = Optional.Absent,
    revisionUrl: Optional[Url] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.SourceRevision = {
    import SourceRevision.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.SourceRevision
      .builder()
      .actionName(ActionName.unwrap(actionName): java.lang.String)
      .optionallyWith(
        revisionId.map(value => Revision.unwrap(value): java.lang.String)
      )(_.revisionId)
      .optionallyWith(
        revisionSummary.map(value =>
          RevisionSummary.unwrap(value): java.lang.String
        )
      )(_.revisionSummary)
      .optionallyWith(
        revisionUrl.map(value => Url.unwrap(value): java.lang.String)
      )(_.revisionUrl)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.SourceRevision.ReadOnly =
    zio.aws.codepipeline.model.SourceRevision.wrap(buildAwsValue())
}
object SourceRevision {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.SourceRevision
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.SourceRevision =
      zio.aws.codepipeline.model.SourceRevision(
        actionName,
        revisionId.map(value => value),
        revisionSummary.map(value => value),
        revisionUrl.map(value => value)
      )
    def actionName: ActionName
    def revisionId: Optional[Revision]
    def revisionSummary: Optional[RevisionSummary]
    def revisionUrl: Optional[Url]
    def getActionName: ZIO[Any, Nothing, ActionName] = ZIO.succeed(actionName)
    def getRevisionId: ZIO[Any, AwsError, Revision] =
      AwsError.unwrapOptionField("revisionId", revisionId)
    def getRevisionSummary: ZIO[Any, AwsError, RevisionSummary] =
      AwsError.unwrapOptionField("revisionSummary", revisionSummary)
    def getRevisionUrl: ZIO[Any, AwsError, Url] =
      AwsError.unwrapOptionField("revisionUrl", revisionUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.SourceRevision
  ) extends zio.aws.codepipeline.model.SourceRevision.ReadOnly {
    override val actionName: ActionName =
      zio.aws.codepipeline.model.primitives.ActionName(impl.actionName())
    override val revisionId: Optional[Revision] = zio.aws.core.internal
      .optionalFromNullable(impl.revisionId())
      .map(value => zio.aws.codepipeline.model.primitives.Revision(value))
    override val revisionSummary: Optional[RevisionSummary] =
      zio.aws.core.internal
        .optionalFromNullable(impl.revisionSummary())
        .map(value =>
          zio.aws.codepipeline.model.primitives.RevisionSummary(value)
        )
    override val revisionUrl: Optional[Url] = zio.aws.core.internal
      .optionalFromNullable(impl.revisionUrl())
      .map(value => zio.aws.codepipeline.model.primitives.Url(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.SourceRevision
  ): zio.aws.codepipeline.model.SourceRevision.ReadOnly = new Wrapper(impl)
}
