package zio.aws.codepipeline.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.codepipeline.model.primitives.{
  ActionConfigurationQueryableValue,
  ActionConfigurationKey,
  MaxBatchSize
}
import scala.jdk.CollectionConverters.*
final case class PollForJobsRequest(
    actionTypeId: zio.aws.codepipeline.model.ActionTypeId,
    maxBatchSize: Optional[MaxBatchSize] = Optional.Absent,
    queryParam: Optional[
      Map[ActionConfigurationKey, ActionConfigurationQueryableValue]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.PollForJobsRequest = {
    import PollForJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.PollForJobsRequest
      .builder()
      .actionTypeId(actionTypeId.buildAwsValue())
      .optionallyWith(
        maxBatchSize.map(value => MaxBatchSize.unwrap(value): Integer)
      )(_.maxBatchSize)
      .optionallyWith(
        queryParam.map(value =>
          value
            .map({ case (key, value) =>
              (ActionConfigurationKey.unwrap(
                key
              ): java.lang.String) -> (ActionConfigurationQueryableValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.queryParam)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.PollForJobsRequest.ReadOnly =
    zio.aws.codepipeline.model.PollForJobsRequest.wrap(buildAwsValue())
}
object PollForJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.PollForJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.PollForJobsRequest =
      zio.aws.codepipeline.model.PollForJobsRequest(
        actionTypeId.asEditable,
        maxBatchSize.map(value => value),
        queryParam.map(value => value)
      )
    def actionTypeId: zio.aws.codepipeline.model.ActionTypeId.ReadOnly
    def maxBatchSize: Optional[MaxBatchSize]
    def queryParam: Optional[
      Map[ActionConfigurationKey, ActionConfigurationQueryableValue]
    ]
    def getActionTypeId
        : ZIO[Any, Nothing, zio.aws.codepipeline.model.ActionTypeId.ReadOnly] =
      ZIO.succeed(actionTypeId)
    def getMaxBatchSize: ZIO[Any, AwsError, MaxBatchSize] =
      AwsError.unwrapOptionField("maxBatchSize", maxBatchSize)
    def getQueryParam: ZIO[Any, AwsError, Map[
      ActionConfigurationKey,
      ActionConfigurationQueryableValue
    ]] = AwsError.unwrapOptionField("queryParam", queryParam)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.PollForJobsRequest
  ) extends zio.aws.codepipeline.model.PollForJobsRequest.ReadOnly {
    override val actionTypeId
        : zio.aws.codepipeline.model.ActionTypeId.ReadOnly =
      zio.aws.codepipeline.model.ActionTypeId.wrap(impl.actionTypeId())
    override val maxBatchSize: Optional[MaxBatchSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maxBatchSize())
      .map(value => zio.aws.codepipeline.model.primitives.MaxBatchSize(value))
    override val queryParam: Optional[
      Map[ActionConfigurationKey, ActionConfigurationQueryableValue]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.queryParam())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.codepipeline.model.primitives.ActionConfigurationKey(
              key
            ) -> zio.aws.codepipeline.model.primitives
              .ActionConfigurationQueryableValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.PollForJobsRequest
  ): zio.aws.codepipeline.model.PollForJobsRequest.ReadOnly = new Wrapper(impl)
}
