package zio.aws.codepipeline.model
import scala.jdk.CollectionConverters.*
sealed trait ArtifactStoreType {
  def unwrap
      : software.amazon.awssdk.services.codepipeline.model.ArtifactStoreType
}
object ArtifactStoreType {
  def wrap(
      value: software.amazon.awssdk.services.codepipeline.model.ArtifactStoreType
  ): zio.aws.codepipeline.model.ArtifactStoreType = value match {
    case software.amazon.awssdk.services.codepipeline.model.ArtifactStoreType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codepipeline.model.ArtifactStoreType.S3 =>
      val r = S3
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codepipeline.model.ArtifactStoreType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.ArtifactStoreType =
      software.amazon.awssdk.services.codepipeline.model.ArtifactStoreType.UNKNOWN_TO_SDK_VERSION
  }
  case object S3 extends zio.aws.codepipeline.model.ArtifactStoreType {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.ArtifactStoreType =
      software.amazon.awssdk.services.codepipeline.model.ArtifactStoreType.S3
  }
}
