package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.StopPipelineExecutionReason
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class StopExecutionTrigger(
    reason: Option[StopPipelineExecutionReason] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.StopExecutionTrigger = {
    import StopExecutionTrigger.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.StopExecutionTrigger
      .builder()
      .optionallyWith(
        reason.map(value =>
          StopPipelineExecutionReason.unwrap(value): java.lang.String
        )
      )(_.reason)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.StopExecutionTrigger.ReadOnly =
    zio.aws.codepipeline.model.StopExecutionTrigger.wrap(buildAwsValue())
}
object StopExecutionTrigger {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.StopExecutionTrigger
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.StopExecutionTrigger =
      zio.aws.codepipeline.model
        .StopExecutionTrigger(reason.map(value => value))
    def reason: Option[StopPipelineExecutionReason]
    def getReason: ZIO[Any, AwsError, StopPipelineExecutionReason] =
      AwsError.unwrapOptionField("reason", reason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.StopExecutionTrigger
  ) extends zio.aws.codepipeline.model.StopExecutionTrigger.ReadOnly {
    override val reason: Option[StopPipelineExecutionReason] = scala
      .Option(impl.reason())
      .map(value =>
        zio.aws.codepipeline.model.primitives.StopPipelineExecutionReason(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.StopExecutionTrigger
  ): zio.aws.codepipeline.model.StopExecutionTrigger.ReadOnly = new Wrapper(
    impl
  )
}
