package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{
  ActionName,
  StageName,
  PipelineName
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PutActionRevisionRequest(
    pipelineName: PipelineName,
    stageName: StageName,
    actionName: ActionName,
    actionRevision: zio.aws.codepipeline.model.ActionRevision
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.PutActionRevisionRequest = {
    import PutActionRevisionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.PutActionRevisionRequest
      .builder()
      .pipelineName(PipelineName.unwrap(pipelineName): java.lang.String)
      .stageName(StageName.unwrap(stageName): java.lang.String)
      .actionName(ActionName.unwrap(actionName): java.lang.String)
      .actionRevision(actionRevision.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.PutActionRevisionRequest.ReadOnly =
    zio.aws.codepipeline.model.PutActionRevisionRequest.wrap(buildAwsValue())
}
object PutActionRevisionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.PutActionRevisionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.PutActionRevisionRequest =
      zio.aws.codepipeline.model.PutActionRevisionRequest(
        pipelineName,
        stageName,
        actionName,
        actionRevision.asEditable
      )
    def pipelineName: PipelineName
    def stageName: StageName
    def actionName: ActionName
    def actionRevision: zio.aws.codepipeline.model.ActionRevision.ReadOnly
    def getPipelineName: ZIO[Any, Nothing, PipelineName] =
      ZIO.succeed(pipelineName)
    def getStageName: ZIO[Any, Nothing, StageName] = ZIO.succeed(stageName)
    def getActionName: ZIO[Any, Nothing, ActionName] = ZIO.succeed(actionName)
    def getActionRevision: ZIO[
      Any,
      Nothing,
      zio.aws.codepipeline.model.ActionRevision.ReadOnly
    ] = ZIO.succeed(actionRevision)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.PutActionRevisionRequest
  ) extends zio.aws.codepipeline.model.PutActionRevisionRequest.ReadOnly {
    override val pipelineName: PipelineName =
      zio.aws.codepipeline.model.primitives.PipelineName(impl.pipelineName())
    override val stageName: StageName =
      zio.aws.codepipeline.model.primitives.StageName(impl.stageName())
    override val actionName: ActionName =
      zio.aws.codepipeline.model.primitives.ActionName(impl.actionName())
    override val actionRevision
        : zio.aws.codepipeline.model.ActionRevision.ReadOnly =
      zio.aws.codepipeline.model.ActionRevision.wrap(impl.actionRevision())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.PutActionRevisionRequest
  ): zio.aws.codepipeline.model.PutActionRevisionRequest.ReadOnly = new Wrapper(
    impl
  )
}
