package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.ArtifactStoreLocation
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ArtifactStore(
    `type`: zio.aws.codepipeline.model.ArtifactStoreType,
    location: ArtifactStoreLocation,
    encryptionKey: Option[zio.aws.codepipeline.model.EncryptionKey] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ArtifactStore = {
    import ArtifactStore.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ArtifactStore
      .builder()
      .`type`(`type`.unwrap)
      .location(ArtifactStoreLocation.unwrap(location): java.lang.String)
      .optionallyWith(encryptionKey.map(value => value.buildAwsValue()))(
        _.encryptionKey
      )
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.ArtifactStore.ReadOnly =
    zio.aws.codepipeline.model.ArtifactStore.wrap(buildAwsValue())
}
object ArtifactStore {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ArtifactStore
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ArtifactStore =
      zio.aws.codepipeline.model.ArtifactStore(
        `type`,
        location,
        encryptionKey.map(value => value.asEditable)
      )
    def `type`: zio.aws.codepipeline.model.ArtifactStoreType
    def location: ArtifactStoreLocation
    def encryptionKey: Option[zio.aws.codepipeline.model.EncryptionKey.ReadOnly]
    def getType
        : ZIO[Any, Nothing, zio.aws.codepipeline.model.ArtifactStoreType] =
      ZIO.succeed(`type`)
    def getLocation: ZIO[Any, Nothing, ArtifactStoreLocation] =
      ZIO.succeed(location)
    def getEncryptionKey: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.EncryptionKey.ReadOnly
    ] = AwsError.unwrapOptionField("encryptionKey", encryptionKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ArtifactStore
  ) extends zio.aws.codepipeline.model.ArtifactStore.ReadOnly {
    override val `type`: zio.aws.codepipeline.model.ArtifactStoreType =
      zio.aws.codepipeline.model.ArtifactStoreType.wrap(impl.`type`())
    override val location: ArtifactStoreLocation =
      zio.aws.codepipeline.model.primitives
        .ArtifactStoreLocation(impl.location())
    override val encryptionKey
        : Option[zio.aws.codepipeline.model.EncryptionKey.ReadOnly] = scala
      .Option(impl.encryptionKey())
      .map(value => zio.aws.codepipeline.model.EncryptionKey.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ArtifactStore
  ): zio.aws.codepipeline.model.ArtifactStore.ReadOnly = new Wrapper(impl)
}
