package zio.aws.codepipeline.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AcknowledgeJobResponse(
    status: Option[zio.aws.codepipeline.model.JobStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.AcknowledgeJobResponse = {
    import AcknowledgeJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.AcknowledgeJobResponse
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.codepipeline.model.AcknowledgeJobResponse.ReadOnly =
    zio.aws.codepipeline.model.AcknowledgeJobResponse.wrap(buildAwsValue())
}
object AcknowledgeJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.AcknowledgeJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.AcknowledgeJobResponse =
      zio.aws.codepipeline.model
        .AcknowledgeJobResponse(status.map(value => value))
    def status: Option[zio.aws.codepipeline.model.JobStatus]
    def getStatus: ZIO[Any, AwsError, zio.aws.codepipeline.model.JobStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.AcknowledgeJobResponse
  ) extends zio.aws.codepipeline.model.AcknowledgeJobResponse.ReadOnly {
    override val status: Option[zio.aws.codepipeline.model.JobStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.codepipeline.model.JobStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.AcknowledgeJobResponse
  ): zio.aws.codepipeline.model.AcknowledgeJobResponse.ReadOnly = new Wrapper(
    impl
  )
}
