package zio.aws.codepipeline.model
import scala.jdk.CollectionConverters.*
sealed trait PipelineExecutionStatus {
  def unwrap: software.amazon.awssdk.services.codepipeline.model.PipelineExecutionStatus
}
object PipelineExecutionStatus {
  def wrap(
      value: software.amazon.awssdk.services.codepipeline.model.PipelineExecutionStatus
  ): zio.aws.codepipeline.model.PipelineExecutionStatus = value match {
    case software.amazon.awssdk.services.codepipeline.model.PipelineExecutionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.codepipeline.model.PipelineExecutionStatus.CANCELLED =>
      val r = Cancelled
      r
    case software.amazon.awssdk.services.codepipeline.model.PipelineExecutionStatus.IN_PROGRESS =>
      val r = InProgress
      r
    case software.amazon.awssdk.services.codepipeline.model.PipelineExecutionStatus.STOPPED =>
      val r = Stopped
      r
    case software.amazon.awssdk.services.codepipeline.model.PipelineExecutionStatus.STOPPING =>
      val r = Stopping
      r
    case software.amazon.awssdk.services.codepipeline.model.PipelineExecutionStatus.SUCCEEDED =>
      val r = Succeeded
      r
    case software.amazon.awssdk.services.codepipeline.model.PipelineExecutionStatus.SUPERSEDED =>
      val r = Superseded
      r
    case software.amazon.awssdk.services.codepipeline.model.PipelineExecutionStatus.FAILED =>
      val r = Failed
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.codepipeline.model.PipelineExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.PipelineExecutionStatus =
      software.amazon.awssdk.services.codepipeline.model.PipelineExecutionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object Cancelled
      extends zio.aws.codepipeline.model.PipelineExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.PipelineExecutionStatus =
      software.amazon.awssdk.services.codepipeline.model.PipelineExecutionStatus.CANCELLED
  }
  case object InProgress
      extends zio.aws.codepipeline.model.PipelineExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.PipelineExecutionStatus =
      software.amazon.awssdk.services.codepipeline.model.PipelineExecutionStatus.IN_PROGRESS
  }
  case object Stopped
      extends zio.aws.codepipeline.model.PipelineExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.PipelineExecutionStatus =
      software.amazon.awssdk.services.codepipeline.model.PipelineExecutionStatus.STOPPED
  }
  case object Stopping
      extends zio.aws.codepipeline.model.PipelineExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.PipelineExecutionStatus =
      software.amazon.awssdk.services.codepipeline.model.PipelineExecutionStatus.STOPPING
  }
  case object Succeeded
      extends zio.aws.codepipeline.model.PipelineExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.PipelineExecutionStatus =
      software.amazon.awssdk.services.codepipeline.model.PipelineExecutionStatus.SUCCEEDED
  }
  case object Superseded
      extends zio.aws.codepipeline.model.PipelineExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.PipelineExecutionStatus =
      software.amazon.awssdk.services.codepipeline.model.PipelineExecutionStatus.SUPERSEDED
  }
  case object Failed
      extends zio.aws.codepipeline.model.PipelineExecutionStatus {
    override def unwrap
        : software.amazon.awssdk.services.codepipeline.model.PipelineExecutionStatus =
      software.amazon.awssdk.services.codepipeline.model.PipelineExecutionStatus.FAILED
  }
}
