package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.JobId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PutJobFailureResultRequest(
    jobId: JobId,
    failureDetails: zio.aws.codepipeline.model.FailureDetails
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.PutJobFailureResultRequest = {
    import PutJobFailureResultRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.PutJobFailureResultRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .failureDetails(failureDetails.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.codepipeline.model.PutJobFailureResultRequest.ReadOnly =
    zio.aws.codepipeline.model.PutJobFailureResultRequest.wrap(buildAwsValue())
}
object PutJobFailureResultRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.PutJobFailureResultRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.PutJobFailureResultRequest =
      zio.aws.codepipeline.model
        .PutJobFailureResultRequest(jobId, failureDetails.asEditable)
    def jobId: JobId
    def failureDetails: zio.aws.codepipeline.model.FailureDetails.ReadOnly
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getFailureDetails: ZIO[
      Any,
      Nothing,
      zio.aws.codepipeline.model.FailureDetails.ReadOnly
    ] = ZIO.succeed(failureDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.PutJobFailureResultRequest
  ) extends zio.aws.codepipeline.model.PutJobFailureResultRequest.ReadOnly {
    override val jobId: JobId =
      zio.aws.codepipeline.model.primitives.JobId(impl.jobId())
    override val failureDetails
        : zio.aws.codepipeline.model.FailureDetails.ReadOnly =
      zio.aws.codepipeline.model.FailureDetails.wrap(impl.failureDetails())
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.PutJobFailureResultRequest
  ): zio.aws.codepipeline.model.PutJobFailureResultRequest.ReadOnly =
    new Wrapper(impl)
}
