package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{ClientRequestToken, PipelineName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class StartPipelineExecutionRequest(
    name: PipelineName,
    clientRequestToken: Option[ClientRequestToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.StartPipelineExecutionRequest = {
    import StartPipelineExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.StartPipelineExecutionRequest
      .builder()
      .name(PipelineName.unwrap(name): java.lang.String)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codepipeline.model.StartPipelineExecutionRequest.ReadOnly =
    zio.aws.codepipeline.model.StartPipelineExecutionRequest
      .wrap(buildAwsValue())
}
object StartPipelineExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.StartPipelineExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.StartPipelineExecutionRequest =
      zio.aws.codepipeline.model.StartPipelineExecutionRequest(
        name,
        clientRequestToken.map(value => value)
      )
    def name: PipelineName
    def clientRequestToken: Option[ClientRequestToken]
    def getName: ZIO[Any, Nothing, PipelineName] = ZIO.succeed(name)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.StartPipelineExecutionRequest
  ) extends zio.aws.codepipeline.model.StartPipelineExecutionRequest.ReadOnly {
    override val name: PipelineName =
      zio.aws.codepipeline.model.primitives.PipelineName(impl.name())
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value =>
        zio.aws.codepipeline.model.primitives.ClientRequestToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.StartPipelineExecutionRequest
  ): zio.aws.codepipeline.model.StartPipelineExecutionRequest.ReadOnly =
    new Wrapper(impl)
}
