package zio.aws.codepipeline.model
import zio.aws.codepipeline.model.primitives.{
  NextToken,
  MaxResults,
  PipelineName
}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListActionExecutionsRequest(
    pipelineName: PipelineName,
    filter: Option[zio.aws.codepipeline.model.ActionExecutionFilter] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.codepipeline.model.ListActionExecutionsRequest = {
    import ListActionExecutionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.codepipeline.model.ListActionExecutionsRequest
      .builder()
      .pipelineName(PipelineName.unwrap(pipelineName): java.lang.String)
      .optionallyWith(filter.map(value => value.buildAwsValue()))(_.filter)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.codepipeline.model.ListActionExecutionsRequest.ReadOnly =
    zio.aws.codepipeline.model.ListActionExecutionsRequest.wrap(buildAwsValue())
}
object ListActionExecutionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.codepipeline.model.ListActionExecutionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.codepipeline.model.ListActionExecutionsRequest =
      zio.aws.codepipeline.model.ListActionExecutionsRequest(
        pipelineName,
        filter.map(value => value.asEditable),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def pipelineName: PipelineName
    def filter
        : Option[zio.aws.codepipeline.model.ActionExecutionFilter.ReadOnly]
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getPipelineName: ZIO[Any, Nothing, PipelineName] =
      ZIO.succeed(pipelineName)
    def getFilter: ZIO[
      Any,
      AwsError,
      zio.aws.codepipeline.model.ActionExecutionFilter.ReadOnly
    ] = AwsError.unwrapOptionField("filter", filter)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.codepipeline.model.ListActionExecutionsRequest
  ) extends zio.aws.codepipeline.model.ListActionExecutionsRequest.ReadOnly {
    override val pipelineName: PipelineName =
      zio.aws.codepipeline.model.primitives.PipelineName(impl.pipelineName())
    override val filter
        : Option[zio.aws.codepipeline.model.ActionExecutionFilter.ReadOnly] =
      scala
        .Option(impl.filter())
        .map(value =>
          zio.aws.codepipeline.model.ActionExecutionFilter.wrap(value)
        )
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.codepipeline.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.codepipeline.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.codepipeline.model.ListActionExecutionsRequest
  ): zio.aws.codepipeline.model.ListActionExecutionsRequest.ReadOnly =
    new Wrapper(impl)
}
